/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.storage.file.hocon;

import io.github.aquerr.eaglefactions.api.entities.FactionPlayer;
import io.github.aquerr.eaglefactions.common.storage.PlayerStorage;
import io.github.aquerr.eaglefactions.common.storage.file.hocon.ConfigurateHelper;
import io.github.aquerr.eaglefactions.common.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;

public class HOCONPlayerStorage
implements PlayerStorage {
    private Path playersDirectoryPath;

    public HOCONPlayerStorage(Path configDir) {
        try {
            this.playersDirectoryPath = configDir.resolve("players");
            if (!Files.exists(this.playersDirectoryPath, new LinkOption[0])) {
                Files.createDirectory(this.playersDirectoryPath, new FileAttribute[0]);
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public FactionPlayer getPlayer(UUID playerUUID) {
        Path playerFilePath = this.playersDirectoryPath.resolve(playerUUID.toString() + ".conf");
        if (Files.notExists(playerFilePath, new LinkOption[0])) {
            return null;
        }
        return ConfigurateHelper.getPlayerFromFile(playerFilePath.toFile());
    }

    @Override
    public boolean savePlayer(FactionPlayer player) {
        try {
            FileUtils.createDirectoryIfNotExists(this.playersDirectoryPath);
            Path playerFile = this.playersDirectoryPath.resolve(player.getUniqueId().toString() + ".conf");
            HoconConfigurationLoader configurationLoader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setDefaultOptions(ConfigurateHelper.getDefaultOptions())).setPath(playerFile)).build();
            ConfigurationNode configurationNode = configurationLoader.load();
            configurationNode.getNode(new Object[]{"name"}).setValue((Object)player.getName());
            configurationNode.getNode(new Object[]{"faction"}).setValue((Object)player.getFactionName().orElse(""));
            configurationNode.getNode(new Object[]{"power"}).setValue((Object)Float.valueOf(player.getPower()));
            configurationNode.getNode(new Object[]{"maxpower"}).setValue((Object)Float.valueOf(player.getMaxPower()));
            configurationNode.getNode(new Object[]{"death-in-warzone"}).setValue((Object)false);
            configurationLoader.save(configurationNode);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean savePlayers(List<FactionPlayer> players) {
        for (FactionPlayer player : players) {
            this.savePlayer(player);
        }
        return true;
    }

    @Override
    public Set<String> getServerPlayerNames() {
        HashSet<String> playerSet = new HashSet<String>();
        File playerDir = new File(this.playersDirectoryPath.toUri());
        File[] playerFiles = playerDir.listFiles();
        if (playerFiles == null) {
            return playerSet;
        }
        for (File playerFile : playerFiles) {
            HoconConfigurationLoader configurationLoader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setDefaultOptions(ConfigurateHelper.getDefaultOptions())).setPath(playerFile.toPath())).build();
            try {
                ConfigurationNode configurationNode = configurationLoader.load();
                playerSet.add(configurationNode.getNode(new Object[]{"name"}).getString(""));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return playerSet;
    }

    @Override
    public Set<FactionPlayer> getServerPlayers() {
        HashSet<FactionPlayer> playerSet = new HashSet<FactionPlayer>();
        File playerDir = new File(this.playersDirectoryPath.toUri());
        File[] playerFiles = playerDir.listFiles();
        if (playerFiles == null) {
            return playerSet;
        }
        for (File playerFile : playerFiles) {
            FactionPlayer factionPlayer = ConfigurateHelper.getPlayerFromFile(playerFile);
            if (factionPlayer == null) continue;
            playerSet.add(factionPlayer);
        }
        return playerSet;
    }

    @Override
    public void deletePlayers() {
        File[] files = this.playersDirectoryPath.toFile().listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            files[i].delete();
        }
    }
}

