/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.util;

import io.github.aquerr.eaglefactions.api.exception.RequiredItemsNotFoundException;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.entity.PlayerInventory;
import org.spongepowered.api.item.inventory.query.QueryOperation;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;

public class ItemUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemUtil.class);

    public static void pollItemsNeededForClaimFromPlayer(Player player) throws RequiredItemsNotFoundException {
        Map<String, Integer> requiredItems = EagleFactionsPlugin.getPlugin().getConfiguration().getFactionsConfig().getRequiredItemsToClaim();
        List<ItemStack> itemStacks = ItemUtil.convertToItemStackList(requiredItems);
        ItemUtil.pollItemsFromPlayer(player, itemStacks);
    }

    public static void pollItemsNeededForCreationFromPlayer(Player player) throws RequiredItemsNotFoundException {
        Map<String, Integer> requiredItems = EagleFactionsPlugin.getPlugin().getConfiguration().getFactionsConfig().getRequiredItemsToCreateFaction();
        List<ItemStack> itemStacks = ItemUtil.convertToItemStackList(requiredItems);
        ItemUtil.pollItemsFromPlayer(player, itemStacks);
    }

    public static List<ItemStack> convertToItemStackList(Map<String, Integer> items) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>(items.size());
        for (String requiredItem : items.keySet()) {
            String[] idAndVariant = requiredItem.split(":");
            String itemId = idAndVariant[0] + ":" + idAndVariant[1];
            Optional itemType = Sponge.getRegistry().getType(ItemType.class, itemId);
            if (!itemType.isPresent()) {
                LOGGER.warn("ItemType has not been found for id = " + itemId);
                continue;
            }
            ItemStack itemStack = ItemStack.builder().itemType((ItemType)itemType.get()).build();
            itemStack.setQuantity(items.get(requiredItem).intValue());
            if (idAndVariant.length == 3 && ((ItemType)itemType.get()).getBlock().isPresent()) {
                int variant = Integer.parseInt(idAndVariant[2]);
                BlockState blockState = (BlockState)((BlockType)((ItemType)itemType.get()).getBlock().get()).getAllBlockStates().toArray()[variant];
                itemStack = ItemStack.builder().fromBlockState(blockState).build();
            }
            itemStacks.add(itemStack);
        }
        return itemStacks;
    }

    public static void pollItemsFromPlayer(Player player, List<ItemStack> items) throws RequiredItemsNotFoundException {
        PlayerInventory inventory = (PlayerInventory)player.getInventory().query(new QueryOperation[]{QueryOperationTypes.INVENTORY_TYPE.of(PlayerInventory.class)});
        for (ItemStack itemStack : items) {
            if (inventory.contains(itemStack)) continue;
            throw new RequiredItemsNotFoundException("Could not found required items in player's inventory. Missing item = " + itemStack);
        }
        for (ItemStack itemStack : items) {
            inventory.query(new QueryOperation[]{QueryOperationTypes.ITEM_TYPE.of((Object)itemStack.getType())}).poll(itemStack.getQuantity());
        }
    }
}

