/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.util;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.common.scheduling.EagleFactionsConsumerTask;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.particle.ParticleOptions;
import org.spongepowered.api.effect.particle.ParticleTypes;
import org.spongepowered.api.effect.sound.SoundTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public final class ParticlesUtil {
    private ParticlesUtil() {
    }

    public static void spawnAddAccessParticles(Claim claim) {
        Optional optionalWorld = Sponge.getServer().getWorld(claim.getWorldUUID());
        if (!optionalWorld.isPresent()) {
            return;
        }
        World world = (World)optionalWorld.get();
        Vector3d position = ParticlesUtil.getChunkCenter(world, claim.getChunkPosition());
        world.spawnParticles(ParticleEffect.builder().type(ParticleTypes.FIREWORKS_SPARK).option(ParticleOptions.VELOCITY, (Object)new Vector3d(0.0, 0.15, 0.0)).quantity(400).offset(new Vector3d(8.0f, 2.0f, 8.0f)).build(), position);
        world.playSound(SoundTypes.ENTITY_EXPERIENCE_ORB_PICKUP, position, 5.0, 10.0);
    }

    public static void spawnRemoveAccessParticles(Claim claim) {
        Optional optionalWorld = Sponge.getServer().getWorld(claim.getWorldUUID());
        if (!optionalWorld.isPresent()) {
            return;
        }
        World world = (World)optionalWorld.get();
        Vector3d position = ParticlesUtil.getChunkCenter(world, claim.getChunkPosition());
        world.spawnParticles(ParticleEffect.builder().type(ParticleTypes.LARGE_SMOKE).option(ParticleOptions.VELOCITY, (Object)new Vector3d(0.0, 0.15, 0.0)).quantity(400).offset(new Vector3d(8.0f, 1.0f, 8.0f)).build(), position);
        world.playSound(SoundTypes.ITEM_FIRECHARGE_USE, position, 5.0, -10.0);
    }

    public static void spawnClaimParticles(Claim claim) {
        Optional optionalWorld = Sponge.getServer().getWorld(claim.getWorldUUID());
        if (!optionalWorld.isPresent()) {
            return;
        }
        World world = (World)optionalWorld.get();
        Vector3d position = ParticlesUtil.getChunkCenter(world, claim.getChunkPosition());
        world.spawnParticles(ParticleEffect.builder().type(ParticleTypes.END_ROD).option(ParticleOptions.VELOCITY, (Object)new Vector3d(0.0, 0.15, 0.0)).quantity(400).offset(new Vector3d(8.0f, 1.0f, 8.0f)).build(), position);
        world.playSound(SoundTypes.BLOCK_ENDERCHEST_OPEN, position, 5.0, -20.0);
    }

    public static void spawnUnclaimParticles(Claim claim) {
        Optional optionalWorld = Sponge.getServer().getWorld(claim.getWorldUUID());
        if (!optionalWorld.isPresent()) {
            return;
        }
        World world = (World)optionalWorld.get();
        Vector3d position = ParticlesUtil.getChunkCenter(world, claim.getChunkPosition());
        world.spawnParticles(ParticleEffect.builder().type(ParticleTypes.CLOUD).option(ParticleOptions.VELOCITY, (Object)new Vector3d(0.0, 0.15, 0.0)).quantity(800).offset(new Vector3d(8.0f, 1.0f, 8.0f)).build(), position);
        world.playSound(SoundTypes.ENTITY_SHULKER_SHOOT, position, 5.0, -20.0);
    }

    public static void spawnDestroyClaimParticles(Claim claim) {
        Optional optionalWorld = Sponge.getServer().getWorld(claim.getWorldUUID());
        if (!optionalWorld.isPresent()) {
            return;
        }
        World world = (World)optionalWorld.get();
        Vector3d position = ParticlesUtil.getChunkCenter(world, claim.getChunkPosition());
        world.spawnParticles(ParticleEffect.builder().type(ParticleTypes.FLAME).option(ParticleOptions.VELOCITY, (Object)new Vector3d(0.0, 0.15, 0.0)).quantity(800).offset(new Vector3d(8.0f, 1.0f, 8.0f)).build(), position);
        world.playSound(SoundTypes.ENTITY_BLAZE_SHOOT, position, 5.0, -20.0);
    }

    public static Vector3d getChunkCenter(World world, Vector3i chunkPosition) {
        double x = (chunkPosition.getX() << 4) + 8;
        double z = (chunkPosition.getZ() << 4) + 8;
        double y = world.getHighestYAt((int)x, (int)z);
        return new Vector3d(x, y, z);
    }

    public static class HomeParticles
    implements EagleFactionsConsumerTask<Task> {
        private final Player player;
        private final World world;
        private final Location<World> location;
        private final double r = 0.6;
        private final double numberOfParticles = 28.0;
        private final double angleIncrement = 0.2243994752564138;
        private double angle = 0.0;
        private final Vector3i lastBlockPosition;

        public HomeParticles(Player player) {
            this.player = player;
            this.world = player.getWorld();
            this.location = player.getLocation();
            this.lastBlockPosition = player.getLocation().getBlockPosition();
        }

        @Override
        public void accept(Task task) {
            double x = this.location.getX() + 0.6 * Math.cos(this.angle);
            double z = this.location.getZ() + 0.6 * Math.sin(this.angle);
            this.world.spawnParticles(ParticleEffect.builder().type(ParticleTypes.END_ROD).quantity(5).offset(Vector3d.from((double)0.0, (double)0.5, (double)0.0)).build(), Vector3d.from((double)x, (double)(this.location.getY() + 0.5), (double)z));
            this.angle = this.angle + 0.2243994752564138 > 360.0 ? this.angle + 0.2243994752564138 - 360.0 : (this.angle += 0.2243994752564138);
            if (!this.lastBlockPosition.equals((Object)this.player.getLocation().getBlockPosition()) || !this.player.isOnline()) {
                task.cancel();
            }
        }
    }
}

