/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cxlibrary.gui.control;

import cubex2.cxlibrary.gui.control.Anchor;
import cubex2.cxlibrary.gui.control.Control;
import cubex2.cxlibrary.gui.control.ControlContainer;
import cubex2.cxlibrary.gui.data.GuiData;

public abstract class ControlBuilder<T extends Control> {
    protected final ControlContainer parent;
    protected final Anchor anchor;
    protected final GuiData data;
    private final String name;

    public ControlBuilder(GuiData data, String name, ControlContainer parent) {
        this.parent = parent;
        this.data = data;
        this.name = name;
        this.anchor = name != null ? data.apply(name, parent, parent) : new Anchor();
    }

    public T add() {
        T control = this.createInstance();
        this.parent.addChild(control, this.name);
        return control;
    }

    protected abstract T createInstance();

    public ControlBuilder<T> left(int dist) {
        return this.left(this.parent, dist, true);
    }

    public ControlBuilder<T> left(Control c, int dist) {
        return this.left(c, dist, false);
    }

    public ControlBuilder<T> left(Control c, int dist, boolean sameSide) {
        this.anchor.left(c, dist, sameSide);
        return this;
    }

    public ControlBuilder<T> right(int dist) {
        return this.right(this.parent, dist, true);
    }

    public ControlBuilder<T> right(Control c, int dist) {
        return this.right(c, dist, false);
    }

    public ControlBuilder<T> right(Control c, int dist, boolean sameSide) {
        this.anchor.right(c, dist, sameSide);
        return this;
    }

    public ControlBuilder<T> top(int dist) {
        return this.top(this.parent, dist, true);
    }

    public ControlBuilder<T> top(Control c, int dist) {
        return this.top(c, dist, false);
    }

    public ControlBuilder<T> top(Control c, int dist, boolean sameSide) {
        this.anchor.top(c, dist, sameSide);
        return this;
    }

    public ControlBuilder<T> bottom(int dist) {
        return this.bottom(this.parent, dist, true);
    }

    public ControlBuilder<T> bottom(Control c, int dist) {
        return this.bottom(c, dist, false);
    }

    public ControlBuilder<T> bottom(Control c, int dist, boolean sameSide) {
        this.anchor.bottom(c, dist, sameSide);
        return this;
    }

    public ControlBuilder<T> size(int w, int h) {
        this.anchor.size(w, h);
        return this;
    }

    public ControlBuilder<T> centerHorIn(Control c) {
        return this.left(c, 0, true).right(c, 0, true);
    }

    public ControlBuilder<T> centerVertIn(Control c) {
        return this.top(c, 0, true).bottom(c, 0, true);
    }

    public ControlBuilder<T> centerHorBetween(Control left, Control right) {
        return this.left(left, 0, false).right(right, 0, false);
    }

    public ControlBuilder<T> centerVertBetween(Control top, Control bottom) {
        return this.top(top, 0, false).bottom(bottom, 0, false);
    }
}

