/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cxlibrary.gui.control;

import cubex2.cxlibrary.gui.control.Anchor;
import cubex2.cxlibrary.gui.control.Control;
import cubex2.cxlibrary.gui.control.ControlBuilder;
import cubex2.cxlibrary.gui.control.ControlContainer;
import cubex2.cxlibrary.gui.data.GuiData;
import java.util.Collections;
import net.minecraft.inventory.Slot;

public class SlotControl
extends Control {
    private String hoveringText;
    private final Slot slot;

    public SlotControl(Slot slot, Anchor anchor, ControlContainer parent) {
        super(anchor, parent);
        this.slot = slot;
    }

    public void setHoveringText(String hoveringText) {
        this.hoveringText = hoveringText;
    }

    public Slot getSlot() {
        return this.slot;
    }

    @Override
    public void drawForeground(int mouseX, int mouseY, float partialTicks) {
        if (this.isMouseOverControl(mouseX, mouseY)) {
            if (this.hoveringText != null) {
                this.screen.gui.drawTheHoveringText(Collections.singletonList(this.hoveringText), mouseX, mouseY);
            } else if (this.mc.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.slot.func_75216_d()) {
                this.screen.gui.renderTheToolTip(this.slot.func_75211_c(), mouseX, mouseY);
            }
        }
    }

    @Override
    public void updateBounds() {
        super.updateBounds();
        this.slot.field_75223_e = this.getX() - this.parent.getX();
        this.slot.field_75221_f = this.getY() - this.parent.getY();
    }

    public static class Builder
    extends ControlBuilder<SlotControl> {
        public final Slot slot;

        public Builder(Slot slot, GuiData data, String name, ControlContainer parent) {
            super(data, name, parent);
            this.slot = slot;
            this.anchor.size(16, 16);
        }

        @Override
        protected SlotControl createInstance() {
            return new SlotControl(this.slot, this.anchor, this.parent);
        }
    }
}

