/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.internal.traits.InternalServiceManagerTrait;
import io.github.nucleuspowered.nucleus.modules.chat.config.ChatTemplateConfig;
import io.github.nucleuspowered.nucleus.modules.chat.util.TemplateUtil;
import io.github.nucleuspowered.nucleus.modules.nickname.services.NicknameService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextElement;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.text.serializer.TextSerializers;

public class NameUtil
implements InternalServiceManagerTrait {
    private static final Map<Character, TextColor> colourMap = Maps.newHashMap();
    private static final Map<Character, TextStyle> styleMap = Maps.newHashMap();
    private static final Map<String, TextStyle> styleMapFull = Maps.newHashMap();
    private static final Map<Character, String> styleKeyMap = Maps.newHashMap();
    private static final String OBFUSICATED = "OBFUSICATED";
    private static final String BOLD = "BOLD";
    private static final String STRIKETHROUGH = "STRIKETHROUGH";
    private static final String UNDERLINE = "UNDERLINE";
    private static final String ITALIC = "ITALIC";
    private static final String RESET = "RESET";

    public static ImmutableMap<Character, TextColor> getColours() {
        return ImmutableMap.copyOf(colourMap);
    }

    public static ImmutableMap<Character, TextStyle> getStyles() {
        return ImmutableMap.copyOf(styleMap);
    }

    public static ImmutableMap<Character, String> getStyleKeys() {
        return ImmutableMap.copyOf(styleKeyMap);
    }

    public Optional<Text> getName(UUID player) {
        return ((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).get(player).map(this::getName);
    }

    public Text getName(User player) {
        List lt;
        Preconditions.checkNotNull((Object)player);
        TextColor tc = this.getNameColour(player);
        TextStyle ts = this.getNameStyle(player);
        Text.Builder tb = this.getService(NicknameService.class).map(service -> service.getNicknameWithPrefix(player).map(Text::toBuilder).orElse(null)).orElseGet(() -> player.get(Keys.DISPLAY_NAME).map(Text::toBuilder).orElseGet(() -> Text.builder((String)player.getName())));
        tb.onHover((HoverAction)TextActions.showText((Text)Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("name.hover.ign", player.getName()))).build();
        if (tc != TextColors.NONE && tb.getColor() == TextColors.NONE && ((lt = tb.getChildren()).isEmpty() || ((Text)lt.get(0)).getColor().equals(TextColors.NONE))) {
            tb.color(tc);
        }
        if (!ts.isEmpty()) {
            tb.style(new TextStyle[]{ts});
        }
        return tb.build();
    }

    public String getSerialisedName(User player) {
        return TextSerializers.FORMATTING_CODE.serialize(this.getName(player));
    }

    public String getNameFromUUID(UUID uuid) {
        if (Util.consoleFakeUUID.equals(uuid)) {
            return Sponge.getServer().getConsole().getName();
        }
        UserStorageService uss = (UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class);
        Optional user = uss.get(uuid);
        return user.map(User::getName).orElseGet(() -> Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("standard.unknown", new String[0]));
    }

    public TextColor getColourFromString(@Nullable String s) {
        if (s == null || s.length() == 0) {
            return TextColors.NONE;
        }
        if (s.length() == 1) {
            return colourMap.getOrDefault(Character.valueOf(s.charAt(0)), TextColors.NONE);
        }
        return Sponge.getRegistry().getType(TextColor.class, s.toUpperCase()).orElse(TextColors.NONE);
    }

    public TextStyle getTextStyleFromString(@Nullable String s) {
        if (s == null || s.length() == 0) {
            return TextStyles.NONE;
        }
        TextStyle ts = TextStyles.NONE;
        for (String split : s.split("\\s*,\\s*")) {
            ts = split.length() == 1 ? ts.and(new TextStyle[]{styleMap.getOrDefault(Character.valueOf(split.charAt(0)), TextStyles.NONE)}) : ts.and(new TextStyle[]{styleMapFull.getOrDefault(split.toUpperCase(), TextStyles.NONE)});
        }
        return ts;
    }

    private TextColor getNameColour(User player) {
        return this.getStyle(player, this::getColourFromString, x -> this.getColourFromString(x.getNamecolour()), (TextElement)TextColors.NONE, "namecolor", "namecolour");
    }

    private TextStyle getNameStyle(User player) {
        return this.getStyle(player, this::getTextStyleFromString, x -> this.getTextStyleFromString(x.getNamestyle()), TextStyles.NONE, "namestyle");
    }

    private <T extends TextElement> T getStyle(User player, Function<String, T> returnIfAvailable, Function<ChatTemplateConfig, T> fromTemplate, T def, String ... options) {
        Optional<String> os = Util.getOptionFromSubject((Subject)player, options);
        if (os.isPresent()) {
            return (T)((TextElement)returnIfAvailable.apply(os.get()));
        }
        return (T)this.getService(TemplateUtil.class).map(templateUtil -> (TextElement)fromTemplate.apply(templateUtil.getTemplateNow((Subject)player))).orElse(def);
    }

    static {
        colourMap.put(Character.valueOf('0'), TextColors.BLACK);
        colourMap.put(Character.valueOf('1'), TextColors.DARK_BLUE);
        colourMap.put(Character.valueOf('2'), TextColors.DARK_GREEN);
        colourMap.put(Character.valueOf('3'), TextColors.DARK_AQUA);
        colourMap.put(Character.valueOf('4'), TextColors.DARK_RED);
        colourMap.put(Character.valueOf('5'), TextColors.DARK_PURPLE);
        colourMap.put(Character.valueOf('6'), TextColors.GOLD);
        colourMap.put(Character.valueOf('7'), TextColors.GRAY);
        colourMap.put(Character.valueOf('8'), TextColors.DARK_GRAY);
        colourMap.put(Character.valueOf('9'), TextColors.BLUE);
        colourMap.put(Character.valueOf('a'), TextColors.GREEN);
        colourMap.put(Character.valueOf('b'), TextColors.AQUA);
        colourMap.put(Character.valueOf('c'), TextColors.RED);
        colourMap.put(Character.valueOf('d'), TextColors.LIGHT_PURPLE);
        colourMap.put(Character.valueOf('e'), TextColors.YELLOW);
        colourMap.put(Character.valueOf('f'), TextColors.WHITE);
        styleMapFull.put("OBFUSCATED", (TextStyle)TextStyles.OBFUSCATED);
        styleMapFull.put("MAGIC", (TextStyle)TextStyles.OBFUSCATED);
        styleMapFull.put(BOLD, (TextStyle)TextStyles.BOLD);
        styleMapFull.put(STRIKETHROUGH, (TextStyle)TextStyles.STRIKETHROUGH);
        styleMapFull.put(UNDERLINE, (TextStyle)TextStyles.UNDERLINE);
        styleMapFull.put(ITALIC, (TextStyle)TextStyles.ITALIC);
        styleMapFull.put(RESET, (TextStyle)TextStyles.RESET);
        styleMap.put(Character.valueOf('k'), (TextStyle)TextStyles.OBFUSCATED);
        styleMap.put(Character.valueOf('l'), (TextStyle)TextStyles.BOLD);
        styleMap.put(Character.valueOf('m'), (TextStyle)TextStyles.STRIKETHROUGH);
        styleMap.put(Character.valueOf('n'), (TextStyle)TextStyles.UNDERLINE);
        styleMap.put(Character.valueOf('o'), (TextStyle)TextStyles.ITALIC);
        styleMap.put(Character.valueOf('r'), (TextStyle)TextStyles.RESET);
        styleKeyMap.put(Character.valueOf('k'), OBFUSICATED);
        styleKeyMap.put(Character.valueOf('l'), BOLD);
        styleKeyMap.put(Character.valueOf('m'), STRIKETHROUGH);
        styleKeyMap.put(Character.valueOf('n'), UNDERLINE);
        styleKeyMap.put(Character.valueOf('o'), ITALIC);
        styleKeyMap.put(Character.valueOf('r'), RESET);
    }
}

