/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.messages.MessageProvider;
import io.github.nucleuspowered.nucleus.util.PaginationBuilderWrapper;
import io.github.nucleuspowered.nucleus.util.ThrownFunction;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.mutable.entity.JoinData;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.message.MessageEvent;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryArchetypes;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.item.inventory.InventoryTransformations;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.entity.MainPlayerInventory;
import org.spongepowered.api.item.inventory.property.InventoryDimension;
import org.spongepowered.api.item.inventory.query.QueryOperation;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextRepresentable;
import org.spongepowered.api.text.TextTemplate;
import org.spongepowered.api.text.translation.Translatable;
import org.spongepowered.api.util.Identifiable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class Util {
    public static final DateTimeFormatter FULL_TIME_FORMATTER = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL).withZone(ZoneId.systemDefault());
    public static final Text SPACE = Text.of((String)" ");
    private static final TextTemplate CHAT_TEMPLATE = TextTemplate.of((Object[])new Object[]{TextTemplate.arg((String)"header").build(), TextTemplate.arg((String)"body").build(), TextTemplate.arg((String)"footer").build()});
    public static final String usernameRegexPattern = "[0-9a-zA-Z_]{3,16}";
    public static final Pattern usernameRegex = Pattern.compile("[0-9a-zA-Z_]{3,16}");
    public static final UUID consoleFakeUUID = UUID.fromString("00000000-0000-0000-0000-000000000000");

    private Util() {
    }

    public static Text applyChatTemplate(MessageEvent.MessageFormatter formatter) {
        return Util.applyChatTemplate((TextRepresentable)formatter.getHeader(), (TextRepresentable)formatter.getBody(), (TextRepresentable)formatter.getFooter());
    }

    public static Text applyChatTemplate(TextRepresentable header, TextRepresentable body, TextRepresentable footer) {
        return CHAT_TEMPLATE.apply((Map)ImmutableMap.of((Object)"header", (Object)header, (Object)"body", (Object)body, (Object)"footer", (Object)footer)).build();
    }

    public static UUID getUUID(CommandSource src) {
        if (src instanceof Identifiable) {
            return ((Identifiable)src).getUniqueId();
        }
        return consoleFakeUUID;
    }

    public static Optional<User> getUserFromUUID(UUID uuid) {
        return ((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).get(uuid).map(x -> x.isOnline() ? (User)x.getPlayer().get() : x);
    }

    public static Object getObjectFromUUID(UUID uuid) {
        Optional<Object> user = ((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).get(uuid).map(x -> x.isOnline() ? x.getPlayer().get() : x);
        return user.orElseGet(() -> Sponge.getServer().getConsole());
    }

    public static String getTimeToNow(Instant time) {
        return Util.getTimeToNow(time, "standard.inamoment");
    }

    public static String getTimeToNow(Instant time, String nowkey) {
        return Util.getTimeStringFromSeconds(Instant.now().getEpochSecond() - time.getEpochSecond(), nowkey);
    }

    public static String getTimeStringFromSeconds(long time) {
        return Util.getTimeStringFromSeconds(time, "standard.inamoment");
    }

    public static String getTimeStringFromSeconds(long time, String nowkey) {
        time = Math.abs(time);
        long sec = time % 60L;
        long min = time / 60L % 60L;
        long hour = time / 3600L % 24L;
        long day = time / 86400L;
        MessageProvider messageProvider = Nucleus.getNucleus().getMessageProvider();
        if (time == 0L) {
            return messageProvider.getMessageWithFormat(nowkey, new String[0]);
        }
        StringBuilder sb = new StringBuilder();
        if (day > 0L) {
            sb.append(day).append(" ");
            if (day > 1L) {
                sb.append(messageProvider.getMessageWithFormat("standard.days", new String[0]));
            } else {
                sb.append(messageProvider.getMessageWithFormat("standard.day", new String[0]));
            }
        }
        if (hour > 0L) {
            Util.appendComma(sb);
            sb.append(hour).append(" ");
            if (hour > 1L) {
                sb.append(messageProvider.getMessageWithFormat("standard.hours", new String[0]));
            } else {
                sb.append(messageProvider.getMessageWithFormat("standard.hour", new String[0]));
            }
        }
        if (min > 0L) {
            Util.appendComma(sb);
            sb.append(min).append(" ");
            if (min > 1L) {
                sb.append(messageProvider.getMessageWithFormat("standard.minutes", new String[0]));
            } else {
                sb.append(messageProvider.getMessageWithFormat("standard.minute", new String[0]));
            }
        }
        if (sec > 0L) {
            Util.appendComma(sb);
            sb.append(sec).append(" ");
            if (sec > 1L) {
                sb.append(Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("standard.seconds", new String[0]));
            } else {
                sb.append(Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("standard.second", new String[0]));
            }
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return messageProvider.getMessageWithFormat("standard.unknown", new String[0]);
    }

    public static String getTimeFromTicks(long ticks) {
        if (ticks < 0L || ticks > 23999L) {
            ticks %= 24000L;
        }
        int mins = (int)((double)(ticks % 1000L) / 16.666666666666668);
        long hours = (ticks / 1000L + 6L) % 24L;
        NumberFormat m = NumberFormat.getIntegerInstance();
        m.setMinimumIntegerDigits(2);
        if (hours < 12L) {
            long ahours = hours == 0L ? 12L : hours;
            return MessageFormat.format(Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("standard.time.am", new String[0]), ahours, hours, m.format(mins));
        }
        long ahours = (hours -= 12L) == 0L ? 12L : hours;
        return MessageFormat.format(Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("standard.time.pm", new String[0]), ahours, hours, m.format(mins));
    }

    private static void appendComma(StringBuilder sb) {
        if (sb.length() > 0) {
            sb.append(", ");
        }
    }

    public static boolean isFirstPlay(User player) {
        try {
            Instant firstPlayed = (Instant)((JoinData)player.get(JoinData.class).get()).firstPlayed().get();
            Instant lastPlayed = (Instant)((JoinData)player.get(JoinData.class).get()).lastPlayed().get();
            return firstPlayed.isAfter(lastPlayed.minus(10L, ChronoUnit.SECONDS));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Optional<Double> getDoubleOptionFromSubject(Subject player, String ... options) {
        return Util.getTypedObjectFromSubject(Double::parseDouble, player, options);
    }

    public static Optional<Long> getPositiveLongOptionFromSubject(Subject player, String ... options) {
        return Util.getTypedObjectFromSubject(Long::parseUnsignedLong, player, options);
    }

    public static Optional<Integer> getPositiveIntOptionFromSubject(Subject player, String ... options) {
        return Util.getTypedObjectFromSubject(Integer::parseUnsignedInt, player, options);
    }

    public static Optional<Integer> getIntOptionFromSubject(Subject player, String ... options) {
        return Util.getTypedObjectFromSubject(Integer::parseInt, player, options);
    }

    public static <T> Optional<T> getTypedObjectFromSubject(ThrownFunction<String, T, Exception> conversion, Subject player, String ... options) {
        try {
            Optional<String> optional = Util.getOptionFromSubject(player, options);
            if (optional.isPresent()) {
                return Optional.ofNullable(conversion.apply(optional.get()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    public static Optional<String> getOptionFromSubject(Subject player, String ... options) {
        for (String option : options) {
            String o = option.toLowerCase();
            Optional os = player.getOption(player.getActiveContexts(), o);
            if (os.isPresent()) {
                return os.map(r -> r.isEmpty() ? null : r);
            }
            os = player.getOption(o);
            if (!os.isPresent()) continue;
            return os.map(r -> r.isEmpty() ? null : r);
        }
        return Optional.empty();
    }

    public static Optional<CatalogType> getCatalogTypeForItemFromId(String id) {
        Optional<CatalogType> oit = Sponge.getRegistry().getAllOf(ItemType.class).stream().filter(x -> x.getId().equalsIgnoreCase(id)).findFirst().map(x -> x);
        return oit.map(Optional::of).orElseGet(() -> Sponge.getRegistry().getAllOf(BlockState.class).stream().filter(x -> x.getId().equalsIgnoreCase(id)).findFirst().map(x -> x));
    }

    public static <T extends CatalogType> String getTranslatableIfPresentOnCatalogType(T ct) {
        if (ct instanceof ItemType) {
            return ItemStack.of((ItemType)((ItemType)ct), (int)1).getTranslation().get();
        }
        if (ct instanceof BlockState) {
            return ItemStack.builder().fromBlockState((BlockState)ct).build().getTranslation().get();
        }
        if (ct instanceof Translatable) {
            return Util.getTranslatableIfPresent((Translatable)((CatalogType)((Translatable)ct)));
        }
        return ct.getName();
    }

    public static <T extends Translatable & CatalogType> String getTranslatableIfPresent(T translatable) {
        try {
            String result = translatable.getTranslation().get();
            if (!result.isEmpty()) {
                return result;
            }
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
        return ((CatalogType)translatable).getName();
    }

    public static Optional<String> getKeyIgnoreCase(Map<String, ?> map, String key) {
        return Util.getKeyIgnoreCase(map.keySet(), key);
    }

    public static Optional<String> getKeyIgnoreCase(Collection<String> collection, String key) {
        return collection.stream().filter(x -> x.equalsIgnoreCase(key)).findFirst();
    }

    public static <T> Optional<T> getValueIgnoreCase(Map<String, T> map, String key) {
        return map.entrySet().stream().filter(x -> ((String)x.getKey()).equalsIgnoreCase(key)).map(Map.Entry::getValue).findFirst();
    }

    public static boolean isLocationInWorldBorder(Location<World> location) {
        return Util.isLocationInWorldBorder(location.getPosition(), (World)location.getExtent());
    }

    public static boolean isLocationInWorldBorder(Vector3d location, World world) {
        long radius = (long)Math.floor(world.getWorldBorder().getDiameter() / 2.0);
        Vector3d displacement = location.sub(world.getWorldBorder().getCenter()).abs();
        return !(displacement.getX() > (double)radius) && !(displacement.getZ() > (double)radius);
    }

    public static CompletableFuture<List<Subject>> getParentSubjects(Subject pl) {
        Set contextSet = pl.getActiveContexts();
        return CompletableFuture.supplyAsync(() -> {
            HashMap subjects = Maps.newHashMap();
            Function<Subject, Integer> subjectIntegerFunction = subject -> subjects.computeIfAbsent(subject, k -> k.getParents(contextSet).size());
            return pl.getParents(contextSet).stream().distinct().map(x -> {
                try {
                    return (Subject)x.resolve().get();
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                    return null;
                }
            }).filter(Objects::nonNull).sorted(Comparator.comparingInt(subjectIntegerFunction::apply)).collect(Collectors.toList());
        });
    }

    public static void compressAndDeleteFile(Path from) throws IOException {
        if (Files.exists(from, new LinkOption[0])) {
            Path to = Paths.get(from.toString() + ".gz", new String[0]);
            try (GZIPOutputStream os = new GZIPOutputStream(new FileOutputStream(to.toFile()));){
                Files.copy(from, os);
                ((OutputStream)os).flush();
                Files.delete(from);
            }
        }
    }

    public static PaginationList.Builder getPaginationBuilder(CommandSource source) {
        PaginationList.Builder plb = ((PaginationService)Sponge.getServiceManager().provideUnchecked(PaginationService.class)).builder();
        if (!(source instanceof Player)) {
            plb.linesPerPage(-1);
        }
        return new PaginationBuilderWrapper(plb);
    }

    public static Inventory.Builder getKitInventoryBuilder() {
        return Inventory.builder().of(InventoryArchetypes.CHEST).property("inventorydimension", (InventoryProperty)new InventoryDimension(9, 4));
    }

    public static Optional<CatalogType> getTypeFromItemInHand(Player src) {
        if (src.getItemInHand(HandTypes.MAIN_HAND).isPresent()) {
            return Optional.of(Util.getTypeFromItem((ItemStack)src.getItemInHand(HandTypes.MAIN_HAND).get()));
        }
        return Optional.empty();
    }

    public static CatalogType getTypeFromItem(ItemStack is) {
        block3: {
            try {
                Optional blockState = is.get(Keys.ITEM_BLOCKSTATE);
                if (blockState.isPresent()) {
                    return (CatalogType)blockState.get();
                }
            }
            catch (Exception e) {
                if (!Nucleus.getNucleus().isDebugMode()) break block3;
                e.printStackTrace();
            }
        }
        return is.getType();
    }

    public static ItemStack dropItemOnFloorAtLocation(ItemStackSnapshot itemStackSnapshotToDrop, Location<World> location) {
        return Util.dropItemOnFloorAtLocation(itemStackSnapshotToDrop, (World)location.getExtent(), location.getPosition());
    }

    public static ItemStack dropItemOnFloorAtLocation(ItemStackSnapshot itemStackSnapshotToDrop, World world, Vector3d position) {
        Entity entityToDrop = world.createEntity(EntityTypes.ITEM, position);
        entityToDrop.offer(Keys.REPRESENTED_ITEM, (Object)itemStackSnapshotToDrop);
        world.spawnEntity(entityToDrop);
        return itemStackSnapshotToDrop.createStack();
    }

    public static Inventory getStandardInventory(Carrier player) {
        return player.getInventory().query(new QueryOperation[]{QueryOperationTypes.INVENTORY_TYPE.of(MainPlayerInventory.class)}).transform(InventoryTransformations.PLAYER_MAIN_HOTBAR_FIRST);
    }

    public static <T extends Event> void onPlayerSimulatedOrPlayer(T event, BiConsumer<T, Player> eventConsumer) {
        Player cs = Util.checkSimulated(event).orElseGet(() -> {
            Object root = event.getCause().root();
            if (root instanceof Player) {
                return (Player)root;
            }
            return null;
        });
        if (cs != null) {
            eventConsumer.accept(event, cs);
        }
    }

    public static <T extends Event> void onSourceSimulatedOr(T event, Function<T, Optional<CommandSource>> orElse, BiConsumer<T, CommandSource> eventConsumer) {
        CommandSource cs = Util.checkSimulated(event).map(x -> x).orElseGet(() -> ((Optional)orElse.apply(event)).orElse(null));
        if (cs != null) {
            eventConsumer.accept(event, cs);
        }
    }

    private static Optional<Player> checkSimulated(Event event) {
        return event.getContext().get(EventContextKeys.PLAYER_SIMULATED).map(x -> Sponge.getServer().getPlayer(x.getUniqueId()).orElse(null));
    }
}

