/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.api;

import io.github.nucleuspowered.nucleus.api.service.NucleusAFKService;
import io.github.nucleuspowered.nucleus.api.service.NucleusAPIMetaService;
import io.github.nucleuspowered.nucleus.api.service.NucleusBackService;
import io.github.nucleuspowered.nucleus.api.service.NucleusFreezePlayerService;
import io.github.nucleuspowered.nucleus.api.service.NucleusHomeService;
import io.github.nucleuspowered.nucleus.api.service.NucleusInvulnerabilityService;
import io.github.nucleuspowered.nucleus.api.service.NucleusJailService;
import io.github.nucleuspowered.nucleus.api.service.NucleusKitService;
import io.github.nucleuspowered.nucleus.api.service.NucleusMailService;
import io.github.nucleuspowered.nucleus.api.service.NucleusMessageTokenService;
import io.github.nucleuspowered.nucleus.api.service.NucleusModuleService;
import io.github.nucleuspowered.nucleus.api.service.NucleusMuteService;
import io.github.nucleuspowered.nucleus.api.service.NucleusNameBanService;
import io.github.nucleuspowered.nucleus.api.service.NucleusNicknameService;
import io.github.nucleuspowered.nucleus.api.service.NucleusNoteService;
import io.github.nucleuspowered.nucleus.api.service.NucleusPlayerMetadataService;
import io.github.nucleuspowered.nucleus.api.service.NucleusPrivateMessagingService;
import io.github.nucleuspowered.nucleus.api.service.NucleusRTPService;
import io.github.nucleuspowered.nucleus.api.service.NucleusSeenService;
import io.github.nucleuspowered.nucleus.api.service.NucleusServerShopService;
import io.github.nucleuspowered.nucleus.api.service.NucleusStaffChatService;
import io.github.nucleuspowered.nucleus.api.service.NucleusUserPreferenceService;
import io.github.nucleuspowered.nucleus.api.service.NucleusWarmupManagerService;
import io.github.nucleuspowered.nucleus.api.service.NucleusWarningService;
import io.github.nucleuspowered.nucleus.api.service.NucleusWarpService;
import io.github.nucleuspowered.nucleus.api.service.NucleusWorldUUIDChangeService;
import java.util.Optional;
import org.spongepowered.api.Sponge;

public class NucleusAPI {
    private NucleusAPI() {
    }

    public static NucleusAPIMetaService getMetaService() {
        return NucleusAPI.getService(NucleusAPIMetaService.class).orElseThrow(() -> new IllegalStateException("Nucleus API has not started registering yet"));
    }

    public static NucleusModuleService getModuleService() {
        return NucleusAPI.getService(NucleusModuleService.class).orElseThrow(() -> new IllegalStateException("Nucleus Modules have not been discovered yet"));
    }

    public static NucleusPlayerMetadataService getPlayerMetadataService() {
        return NucleusAPI.getService(NucleusPlayerMetadataService.class).orElseThrow(() -> new IllegalStateException("Nucleus API has not started registering yet"));
    }

    public static NucleusWarmupManagerService getWarmupManagerService() {
        return NucleusAPI.getService(NucleusWarmupManagerService.class).orElseThrow(() -> new IllegalStateException("Nucleus API has not started registering yet"));
    }

    public static NucleusMessageTokenService getMessageTokenService() {
        return NucleusAPI.getService(NucleusMessageTokenService.class).orElseThrow(() -> new IllegalStateException("Message Tokens are not being registered yet"));
    }

    public static NucleusWorldUUIDChangeService getWorldUUIDChangeService() {
        return NucleusAPI.getService(NucleusWorldUUIDChangeService.class).orElseThrow(() -> new IllegalStateException("World UUID mappings have not yet been loaded"));
    }

    public static NucleusUserPreferenceService getUserPreferenceService() {
        return NucleusAPI.getService(NucleusUserPreferenceService.class).orElseThrow(() -> new IllegalStateException("Nucleus API has not started registering yet"));
    }

    public static Optional<NucleusAFKService> getAFKService() {
        return NucleusAPI.getService(NucleusAFKService.class);
    }

    public static Optional<NucleusBackService> getBackService() {
        return NucleusAPI.getService(NucleusBackService.class);
    }

    public static Optional<NucleusFreezePlayerService> getFreezePlayerService() {
        return NucleusAPI.getService(NucleusFreezePlayerService.class);
    }

    public static Optional<NucleusHomeService> getHomeService() {
        return NucleusAPI.getService(NucleusHomeService.class);
    }

    public static Optional<NucleusInvulnerabilityService> getInvulnerabilityService() {
        return NucleusAPI.getService(NucleusInvulnerabilityService.class);
    }

    public static Optional<NucleusJailService> getJailService() {
        return NucleusAPI.getService(NucleusJailService.class);
    }

    public static Optional<NucleusKitService> getKitService() {
        return NucleusAPI.getService(NucleusKitService.class);
    }

    public static Optional<NucleusMailService> getMailService() {
        return NucleusAPI.getService(NucleusMailService.class);
    }

    public static Optional<NucleusMuteService> getMuteService() {
        return NucleusAPI.getService(NucleusMuteService.class);
    }

    public static Optional<NucleusNameBanService> getNameBanService() {
        return NucleusAPI.getService(NucleusNameBanService.class);
    }

    public static Optional<NucleusNicknameService> getNicknameService() {
        return NucleusAPI.getService(NucleusNicknameService.class);
    }

    public static Optional<NucleusNoteService> getNoteService() {
        return NucleusAPI.getService(NucleusNoteService.class);
    }

    public static Optional<NucleusPrivateMessagingService> getPrivateMessagingService() {
        return NucleusAPI.getService(NucleusPrivateMessagingService.class);
    }

    public static Optional<NucleusRTPService> getRTPService() {
        return NucleusAPI.getService(NucleusRTPService.class);
    }

    public static Optional<NucleusSeenService> getSeenService() {
        return NucleusAPI.getService(NucleusSeenService.class);
    }

    public static Optional<NucleusServerShopService> getServerShopService() {
        return NucleusAPI.getService(NucleusServerShopService.class);
    }

    public static Optional<NucleusStaffChatService> getStaffChatService() {
        return NucleusAPI.getService(NucleusStaffChatService.class);
    }

    public static Optional<NucleusWarningService> getWarningService() {
        return NucleusAPI.getService(NucleusWarningService.class);
    }

    public static Optional<NucleusWarpService> getWarpService() {
        return NucleusAPI.getService(NucleusWarpService.class);
    }

    private static <T> Optional<T> getService(Class<T> clazz) {
        return Sponge.getServiceManager().provide(clazz);
    }
}

