/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.api.exceptions;

import java.time.Duration;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.text.Text;

public class KitRedeemException
extends Exception {
    private final Reason reason;

    public KitRedeemException(String message, Reason reason) {
        super(message);
        this.reason = reason;
    }

    public Reason getReason() {
        return this.reason;
    }

    public static enum Reason {
        ALREADY_REDEEMED,
        COOLDOWN_NOT_EXPIRED,
        NO_SPACE,
        PRE_EVENT_CANCELLED,
        UNKNOWN;

    }

    public static class Cooldown
    extends KitRedeemException {
        private final Duration timeLeft;

        public Cooldown(String message, Duration timeLeft) {
            super(message, Reason.COOLDOWN_NOT_EXPIRED);
            this.timeLeft = timeLeft;
        }

        public Duration getTimeLeft() {
            return this.timeLeft;
        }
    }

    public static class PreCancelled
    extends KitRedeemException {
        @Nullable
        private final Text cancelMessage;

        public PreCancelled(@Nullable Text cancelMessage) {
            super(cancelMessage == null ? "Pre event cancelled" : cancelMessage.toPlain(), Reason.PRE_EVENT_CANCELLED);
            this.cancelMessage = cancelMessage;
        }

        public Optional<Text> getCancelMessage() {
            return Optional.ofNullable(this.cancelMessage);
        }
    }
}

