/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.argumentparsers;

import com.google.common.collect.ImmutableList;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.argumentparsers.util.WrappedElement;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.SpongeApiTranslationHelper;

public class TargetHasPermissionArgument
extends WrappedElement {
    private final String userTextKey;
    private final Predicate<Subject> canAccess;

    public TargetHasPermissionArgument(CommandElement key, String userTextKey, @Nullable String permission) {
        this(key, userTextKey, permission == null ? subject -> true : subject -> Nucleus.getNucleus().getPermissionResolver().hasPermission((Subject)subject, permission));
    }

    public TargetHasPermissionArgument(CommandElement key, String userTextKey, Predicate<Subject> canAccess) {
        super(key);
        this.userTextKey = userTextKey;
        this.canAccess = canAccess;
    }

    public void parse(CommandSource source, CommandArgs args, CommandContext context) throws ArgumentParseException {
        Subject subject = (Subject)context.getOne(this.userTextKey).orElse(source);
        if (!this.canAccess.test(subject)) {
            throw args.createError(SpongeApiTranslationHelper.t((String)"You do not have permission to use the unknown argument", (Object[])new Object[0]));
        }
        this.getWrappedElement().parse(source, args, context);
    }

    @Nullable
    protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
        return null;
    }

    public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
        Subject subject = (Subject)context.getOne(this.userTextKey).orElse(src);
        if (this.canAccess.test(subject)) {
            return this.getWrappedElement().complete(src, args, context);
        }
        return ImmutableList.of();
    }

    @Override
    public Text getUsage(CommandSource src) {
        return Text.of((String)"[<key> [value]]");
    }
}

