/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.argumentparsers;

import com.google.common.collect.ImmutableList;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.service.NucleusWarpService;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.traits.InternalServiceManagerTrait;
import io.github.nucleuspowered.nucleus.internal.traits.PermissionTrait;
import io.github.nucleuspowered.nucleus.modules.warp.config.WarpConfig;
import io.github.nucleuspowered.nucleus.modules.warp.config.WarpConfigAdapter;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
public class WarpArgument
extends CommandElement
implements Reloadable,
InternalServiceManagerTrait,
PermissionTrait {
    private NucleusWarpService service;
    private final boolean permissionCheck;
    private boolean separate = true;

    public WarpArgument(@Nullable Text key, boolean permissionCheck) {
        super(key);
        this.permissionCheck = permissionCheck;
        if (this.permissionCheck) {
            Nucleus.getNucleus().registerReloadable(this);
        }
    }

    @Override
    public void onReload() throws Exception {
        this.separate = ((WarpConfig)((WarpConfigAdapter)this.getServiceUnchecked(WarpConfigAdapter.class)).getNodeOrDefault()).isSeparatePermissions();
    }

    @Nullable
    protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
        this.getService();
        String warpName = args.next();
        String warp = warpName.toLowerCase();
        if (!this.service.warpExists(warp)) {
            throw args.createError(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("args.warps.noexist", new String[0]));
        }
        if (this.permissionCheck && this.separate && !this.checkPermission(source, warpName) && !this.checkPermission(source, warpName.toLowerCase())) {
            throw args.createError(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("args.warps.noperms", new String[0]));
        }
        return this.service.getWarp(warpName).orElseThrow(() -> args.createError(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("args.warps.notavailable", new String[0])));
    }

    public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
        this.getService();
        try {
            String el = args.peek();
            String name = el.toLowerCase();
            List<String> elements = this.service.getWarpNames().stream().filter(s -> s.startsWith(name)).limit(21L).collect(Collectors.toList());
            if (elements.size() >= 21) {
                src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("args.warps.maxselect", el));
                return ImmutableList.of((Object)el);
            }
            if (elements.isEmpty()) {
                return ImmutableList.of();
            }
            if (!this.permissionCheck) {
                return elements;
            }
            Predicate<String> predicate = s -> this.service.getWarp((String)s).get().getLocation().isPresent();
            if (this.separate) {
                predicate.and(x -> this.checkPermission(src, (String)x));
            }
            return elements.stream().filter(predicate::test).collect(Collectors.toList());
        }
        catch (ArgumentParseException e) {
            return ImmutableList.of();
        }
    }

    private boolean checkPermission(CommandSource src, String name) {
        return this.hasPermission((Subject)src, "nucleus.warps." + name.toLowerCase());
    }

    private void getService() {
        if (this.service == null) {
            this.service = (NucleusWarpService)Sponge.getServiceManager().provideUnchecked(NucleusWarpService.class);
        }
    }
}

