/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.configurate.datatypes;

import com.flowpowered.math.vector.Vector3d;
import io.github.nucleuspowered.nucleus.api.exceptions.NoSuchWorldException;
import io.github.nucleuspowered.nucleus.configurate.settingprocessor.WorldMigrationSettingProcessor;
import io.github.nucleuspowered.relocate.nucleus.neutrino.annotations.ProcessSetting;
import java.util.Optional;
import java.util.UUID;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.storage.WorldProperties;

@ConfigSerializable
public class LocationNode {
    @Setting
    private double x;
    @Setting
    private double y;
    @Setting
    private double z;
    @Setting
    private double rotx;
    @Setting
    private double roty;
    @Setting
    private double rotz;
    @Setting
    @ProcessSetting(value={WorldMigrationSettingProcessor.class})
    private UUID world;

    public LocationNode() {
    }

    public LocationNode(Location<World> length) {
        this(length, new Vector3d());
    }

    public LocationNode(Location<World> length, Vector3d rotation) {
        this(((World)length.getExtent()).getUniqueId(), length.getPosition(), rotation);
    }

    public LocationNode(UUID world, Vector3d length, Vector3d rotation) {
        this.x = length.getX();
        this.y = length.getY();
        this.z = length.getZ();
        this.rotx = rotation.getX();
        this.roty = rotation.getY();
        this.rotz = rotation.getZ();
        this.world = world;
    }

    public LocationNode copy() {
        return new LocationNode(this.world, this.getPosition(), this.getRotation());
    }

    public Vector3d getPosition() {
        return new Vector3d(this.x, this.y, this.z);
    }

    public UUID getWorld() {
        return this.world;
    }

    public Tuple<WorldProperties, Vector3d> getLocationIfNotLoaded() throws NoSuchWorldException {
        return Sponge.getServer().getWorldProperties(this.world).map(x -> Tuple.of((Object)x, (Object)this.getPosition())).orElseThrow(NoSuchWorldException::new);
    }

    public Location<World> getLocation() throws NoSuchWorldException {
        Optional ow = Sponge.getServer().getWorld(this.world);
        if (ow.isPresent()) {
            return new Location((Extent)ow.get(), this.x, this.y, this.z);
        }
        throw new NoSuchWorldException();
    }

    public Vector3d getRotation() {
        return new Vector3d(this.rotx, this.roty, this.rotz);
    }
}

