/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.configurate.typeserialisers;

import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.configurate.wrappers.NucleusItemStackSnapshot;
import io.github.nucleuspowered.nucleus.util.PrettyPrinter;
import io.github.nucleuspowered.nucleus.util.TypeHelper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import org.slf4j.event.Level;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataTranslators;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.Tuple;

public class NucleusItemStackSnapshotSerialiser
implements TypeSerializer<NucleusItemStackSnapshot> {
    private final TypeToken<ItemStackSnapshot> iss = TypeToken.of(ItemStackSnapshot.class);

    public NucleusItemStackSnapshot deserialize(TypeToken<?> type, ConfigurationNode value) {
        ItemStack snapshot;
        ConfigurationNode data;
        boolean emptyEnchant = false;
        ConfigurationNode ench = value.getNode(new Object[]{"UnsafeData", "ench"});
        if (!ench.isVirtual()) {
            List enchantments = ench.getChildrenList();
            if (enchantments.isEmpty()) {
                value.getNode(new Object[]{"UnsafeData"}).removeChild((Object)"ench");
            } else {
                enchantments.forEach(x -> {
                    try {
                        short id = Short.parseShort(x.getNode(new Object[]{"id"}).getString());
                        short lvl = Short.parseShort(x.getNode(new Object[]{"lvl"}).getString());
                        x.getNode(new Object[]{"id"}).setValue((Object)id);
                        x.getNode(new Object[]{"lvl"}).setValue((Object)lvl);
                    }
                    catch (NumberFormatException e) {
                        x.setValue(null);
                    }
                });
            }
        }
        if (!(data = value.getNode(new Object[]{"Data"})).isVirtual() && data.hasListChildren()) {
            List n = data.getChildrenList().stream().filter(x -> !x.getNode(new Object[]{"DataClass"}).getString("").endsWith("SpongeEnchantmentData") || !x.getNode(new Object[]{"ManipulatorData", "ItemEnchantments"}).isVirtual() && x.getNode(new Object[]{"ManipulatorData", "ItemEnchantments"}).hasListChildren()).collect(Collectors.toList());
            boolean bl = emptyEnchant = n.size() != data.getChildrenList().size();
            if (emptyEnchant) {
                if (n.isEmpty()) {
                    value.removeChild((Object)"Data");
                } else {
                    value.getNode(new Object[]{"Data"}).setValue(n);
                }
            }
        }
        DataContainer dataContainer = DataTranslators.CONFIGURATION_NODE.translate((Object)value);
        Set ldq = dataContainer.getKeys(true);
        for (DataQuery dataQuery : ldq) {
            String el = dataQuery.asString(".");
            if (!el.contains("$Array$")) continue;
            try {
                Tuple<DataQuery, Object> r = TypeHelper.getArray(dataQuery, (DataView)dataContainer);
                dataContainer.set((DataQuery)r.getFirst(), r.getSecond());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            dataContainer.remove(dataQuery);
        }
        try {
            snapshot = ItemStack.builder().fromContainer((DataView)dataContainer).build();
        }
        catch (Exception e) {
            return NucleusItemStackSnapshot.NONE;
        }
        if (snapshot.isEmpty() || snapshot.getType() == ItemTypes.NONE) {
            return NucleusItemStackSnapshot.NONE;
        }
        if (snapshot.getType() == null) {
            PrettyPrinter printer = new PrettyPrinter();
            printer.add("Null item type recorded when trying to create an item stack").centre().hr();
            printer.add("When trying to load item stacks for kits, a null item type was found. This can occur when changing packs and items no longer exist. The item has been discarded.");
            printer.add("Item Info:");
            try {
                printer.add(DataFormats.JSON.write((DataView)dataContainer));
            }
            catch (IOException e) {
                printer.add("Unable to write info");
            }
            printer.log(Nucleus.getNucleus().getLogger(), Level.WARN);
            return NucleusItemStackSnapshot.NONE;
        }
        if (emptyEnchant) {
            snapshot.offer(Keys.ITEM_ENCHANTMENTS, (Object)Lists.newArrayList());
            return new NucleusItemStackSnapshot(snapshot.createSnapshot());
        }
        if (snapshot.get(Keys.ITEM_ENCHANTMENTS).isPresent()) {
            snapshot.offer(Keys.ITEM_ENCHANTMENTS, snapshot.get(Keys.ITEM_ENCHANTMENTS).get());
            return new NucleusItemStackSnapshot(snapshot.createSnapshot());
        }
        return new NucleusItemStackSnapshot(snapshot.createSnapshot());
    }

    public void serialize(TypeToken<?> type, NucleusItemStackSnapshot obj, ConfigurationNode value) throws ObjectMappingException {
        DataContainer view;
        ItemStackSnapshot snapshot = obj.getSnapshot();
        try {
            view = snapshot.toContainer();
        }
        catch (NullPointerException ex) {
            PrettyPrinter printer = new PrettyPrinter();
            printer.add("NPE encountered when trying to save an item to a kit").centre().hr();
            printer.add("When trying to save an item to the kit, Sponge could not turn the item into data Nucleus can save.");
            printer.add("This can occur when changing packs and items no longer exist.");
            printer.hr();
            ItemType itemType = snapshot.getType();
            if (itemType == null) {
                printer.add("The ItemType was set to null, but is not class as an empty snapshot. It will not be saved.");
            } else {
                printer.add("The ItemType was set to {} (name: {}). It will not be saved.", itemType.getId(), itemType.getName());
            }
            printer.hr();
            printer.add("Stack trace:");
            printer.add(ex);
            printer.log(Nucleus.getNucleus().getLogger(), Level.WARN);
            return;
        }
        Map dataQueryObjectMap = view.getValues(true);
        for (Map.Entry entry : dataQueryObjectMap.entrySet()) {
            if (!entry.getValue().getClass().isArray()) continue;
            if (entry.getValue().getClass().getComponentType().isPrimitive()) {
                DataQuery old = (DataQuery)entry.getKey();
                Tuple<DataQuery, List<?>> dqo = TypeHelper.getList(old, entry.getValue());
                view.remove(old);
                view.set((DataQuery)dqo.getFirst(), dqo.getSecond());
                continue;
            }
            view.set((DataQuery)entry.getKey(), (Object)Lists.newArrayList((Object[])((Object[])entry.getValue())));
        }
        value.setValue(DataTranslators.CONFIGURATION_NODE.translate((DataView)view));
    }
}

