/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.internal.messages;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.text.TextParsingUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextRepresentable;
import org.spongepowered.api.text.TextTemplate;
import org.spongepowered.api.text.translation.Translatable;

public abstract class MessageProvider {
    private static final Pattern STRING_REPLACER = Pattern.compile("\\{+[^0-9]+}+");
    private final Map<String, TextTemplate> textTemplateMap = Maps.newHashMap();

    static Locale parseLocaleString(String string) {
        if (string.contains("-") || string.contains("_")) {
            String[] s = string.split("[-_]", 2);
            return new Locale(s[0], s[1]);
        }
        return Locale.forLanguageTag(string);
    }

    public abstract Locale getLocale();

    public abstract Optional<String> getMessageFromKey(String var1);

    public Locale setLocale(String string) {
        return this.setLocale(Locale.forLanguageTag(string));
    }

    public abstract Locale setLocale(Locale var1);

    public String getMessageWithFormat(String key, String ... substitutions) {
        try {
            String valueReplacement = STRING_REPLACER.matcher(this.getMessageFromKey(key).orElseThrow(() -> new IllegalArgumentException("The key " + key + " does not exist!")).replaceAll("'", "''")).replaceAll("'$0'");
            return MessageFormat.format(valueReplacement, substitutions);
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("The message key " + key + " does not exist!");
        }
    }

    public final Text getTextMessageWithFormat(String key, Object ... substitutions) {
        return this.getTextMessageWithTextFormat(key, Arrays.stream(substitutions).map(x -> {
            if (x instanceof User) {
                return Nucleus.getNucleus().getNameUtil().getName((User)x);
            }
            if (x instanceof TextRepresentable) {
                return (TextRepresentable)x;
            }
            if (x instanceof Translatable || x instanceof String) {
                return Text.of((Object[])new Object[]{x});
            }
            return Text.of((String)x.toString());
        }).collect(Collectors.toList()));
    }

    public final Text getTextMessageWithFormat(String key, String ... substitutions) {
        return this.getTextMessageWithTextFormat(key, Arrays.stream(substitutions).map(TextParsingUtils::oldLegacy).collect(Collectors.toList()));
    }

    public final Text getTextMessageWithTextFormat(String key, Text ... substitutions) {
        return this.getTextMessageWithTextFormat(key, Arrays.asList(substitutions));
    }

    private Text getTextMessageWithTextFormat(String key, List<? extends TextRepresentable> textList) {
        TextTemplate template = this.textTemplateMap.computeIfAbsent(key, k -> this.templateCreator(this.getMessageWithFormat((String)k, new String[0])));
        if (textList.isEmpty()) {
            return template.toText();
        }
        HashMap objs = Maps.newHashMap();
        for (int i = 0; i < textList.size(); ++i) {
            objs.put(String.valueOf(i), textList.get(i));
        }
        return template.apply((Map)objs).build();
    }

    private TextTemplate templateCreator(String string) {
        Matcher mat = Pattern.compile("\\{([\\d]+)}").matcher(string);
        ArrayList map = Lists.newArrayList();
        while (mat.find()) {
            map.add(Integer.parseInt(mat.group(1)));
        }
        String[] s = string.split("\\{([\\d]+)}");
        ArrayList objects = Lists.newArrayList();
        Text t = TextParsingUtils.oldLegacy(s[0]);
        TextParsingUtils.StyleTuple tuple = TextParsingUtils.getLastColourAndStyle((TextRepresentable)t, null);
        objects.add(t);
        int count = 1;
        for (Integer x : map) {
            objects.add(TextTemplate.arg((String)x.toString()).optional().color(tuple.colour).style(tuple.style).build());
            if (s.length > count) {
                t = Text.of((Object[])new Object[]{tuple.colour, tuple.style, TextParsingUtils.oldLegacy(s[count])});
                tuple = TextParsingUtils.getLastColourAndStyle((TextRepresentable)t, null);
                objects.add(t);
            }
            ++count;
        }
        return TextTemplate.of((Object[])objects.toArray(new Object[0]));
    }
}

