/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.internal.permissions;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Nucleus;
import java.util.List;
import javax.inject.Singleton;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.service.ChangeServiceProviderEvent;
import org.spongepowered.api.service.ProviderRegistration;
import org.spongepowered.api.service.context.ContextCalculator;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;

@Singleton
public class ServiceChangeListener {
    private boolean isOpOnly;
    private static final ServiceChangeListener INSTANCE = new ServiceChangeListener();
    private final List<ContextCalculator<Subject>> contextCalculators = Lists.newArrayList();

    public static ServiceChangeListener getInstance() {
        return INSTANCE;
    }

    public static boolean isOpOnly() {
        return ServiceChangeListener.INSTANCE.isOpOnly;
    }

    private ServiceChangeListener() {
        Sponge.getEventManager().registerListeners((Object)Nucleus.getNucleus(), (Object)this);
        this.isOpOnly = Sponge.getServiceManager().getRegistration(PermissionService.class).map(this::checkProvider).orElse(true);
    }

    public void registerCalculator(ContextCalculator<Subject> contextCalculator) {
        this.contextCalculators.add(contextCalculator);
        Sponge.getServiceManager().provide(PermissionService.class).ifPresent(x -> x.registerContextCalculator(contextCalculator));
    }

    @Listener(order=Order.POST)
    public void onServiceChange(ChangeServiceProviderEvent event) {
        if (event.getService().isInstance(PermissionService.class)) {
            this.isOpOnly = this.checkProvider(event.getNewProviderRegistration());
            for (ContextCalculator<Subject> contextCalculator : this.contextCalculators) {
                ((PermissionService)event.getNewProvider()).registerContextCalculator(contextCalculator);
            }
        }
    }

    private boolean checkProvider(ProviderRegistration<?> service) {
        return Sponge.getPlatform().getContainer(Platform.Component.IMPLEMENTATION).equals(service.getPlugin());
    }
}

