/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.internal.qsml;

import com.google.common.base.Preconditions;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.NucleusPlugin;
import io.github.nucleuspowered.nucleus.api.exceptions.ModulesLoadedException;
import io.github.nucleuspowered.nucleus.api.exceptions.NoModuleException;
import io.github.nucleuspowered.nucleus.api.exceptions.UnremovableModuleException;
import io.github.nucleuspowered.nucleus.api.service.NucleusModuleService;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.ModuleContainer;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.enums.ConstructionPhase;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.UndisableableModuleException;
import java.util.Set;
import org.spongepowered.api.plugin.Plugin;

public class ModuleRegistrationProxyService
implements NucleusModuleService {
    @Override
    public Set<String> getModulesToLoad() {
        return Nucleus.getNucleus().getModuleContainer().getModules(ModuleContainer.ModuleStatusTristate.ENABLE);
    }

    @Override
    public boolean canDisableModules() {
        return Nucleus.getNucleus().getModuleContainer().getCurrentPhase() == ConstructionPhase.DISCOVERED;
    }

    @Override
    public void removeModule(String module, Object plugin) throws ModulesLoadedException, UnremovableModuleException, NoModuleException {
        if (!this.canDisableModules()) {
            throw new ModulesLoadedException();
        }
        Preconditions.checkNotNull((Object)plugin);
        Plugin pluginAnnotation = plugin.getClass().getAnnotation(Plugin.class);
        if (pluginAnnotation == null) {
            throw new IllegalArgumentException("plugin must be your plugin instance.");
        }
        try {
            Nucleus.getNucleus().getModuleContainer().disableModule(module);
            Nucleus.getNucleus().getLogger().info(NucleusPlugin.getNucleus().getMessageProvider().getMessageWithFormat("nucleus.module.disabled.modulerequest", pluginAnnotation.name(), pluginAnnotation.id(), module));
        }
        catch (IllegalStateException e) {
            throw new ModulesLoadedException();
        }
        catch (UndisableableModuleException e) {
            Nucleus.getNucleus().getLogger().warn(NucleusPlugin.getNucleus().getMessageProvider().getMessageWithFormat("nucleus.module.disabled.forceload", pluginAnnotation.name(), pluginAnnotation.id(), module));
            Nucleus.getNucleus().getLogger().warn(NucleusPlugin.getNucleus().getMessageProvider().getMessageWithFormat("nucleus.module.disabled.forceloadtwo", pluginAnnotation.name()));
            throw new UnremovableModuleException();
        }
        catch (io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.NoModuleException e) {
            throw new NoModuleException();
        }
    }
}

