/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.internal.qsml.module;

import com.google.common.collect.ImmutableMap;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.NucleusPlugin;
import io.github.nucleuspowered.nucleus.annotationprocessor.Store;
import io.github.nucleuspowered.nucleus.api.service.NucleusUserPreferenceService;
import io.github.nucleuspowered.nucleus.config.CommandsConfig;
import io.github.nucleuspowered.nucleus.internal.CommandPermissionHandler;
import io.github.nucleuspowered.nucleus.internal.annotations.APIService;
import io.github.nucleuspowered.nucleus.internal.annotations.RegisterCommandInterceptors;
import io.github.nucleuspowered.nucleus.internal.annotations.RequireExistenceOf;
import io.github.nucleuspowered.nucleus.internal.annotations.RequiresPlatform;
import io.github.nucleuspowered.nucleus.internal.annotations.ReregisterService;
import io.github.nucleuspowered.nucleus.internal.annotations.ServerOnly;
import io.github.nucleuspowered.nucleus.internal.annotations.SkipOnError;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Scan;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.CommandBuilder;
import io.github.nucleuspowered.nucleus.internal.command.ICommandInterceptor;
import io.github.nucleuspowered.nucleus.internal.docgen.DocGenCache;
import io.github.nucleuspowered.nucleus.internal.interfaces.ListenerBase;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.interfaces.ServiceBase;
import io.github.nucleuspowered.nucleus.internal.interfaces.TaskBase;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.ServiceChangeListener;
import io.github.nucleuspowered.nucleus.internal.registry.NucleusRegistryModule;
import io.github.nucleuspowered.nucleus.internal.services.CommandRemapperService;
import io.github.nucleuspowered.nucleus.internal.text.Tokens;
import io.github.nucleuspowered.nucleus.internal.traits.InternalServiceManagerTrait;
import io.github.nucleuspowered.nucleus.internal.traits.MessageProviderTrait;
import io.github.nucleuspowered.nucleus.internal.userprefs.PreferenceKey;
import io.github.nucleuspowered.nucleus.internal.userprefs.UserPrefKeys;
import io.github.nucleuspowered.nucleus.internal.userprefs.UserPreferenceService;
import io.github.nucleuspowered.nucleus.modules.playerinfo.misc.BasicSeenInformationProvider;
import io.github.nucleuspowered.nucleus.modules.playerinfo.services.SeenHandler;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.Module;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.annotations.ModuleData;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.config.AbstractConfigAdapter;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.MissingDependencyException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import ninja.leaping.configurate.commented.SimpleCommentedConfigurationNode;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.context.ContextCalculator;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;

@Store(isRoot=true)
public abstract class StandardModule
implements Module,
InternalServiceManagerTrait,
MessageProviderTrait {
    private final String moduleId;
    private final String moduleName;
    private String packageName;
    protected final Nucleus plugin;
    private final CommandsConfig commandsConfig;
    @Nullable
    private Map<String, List<String>> objectTypesToClassListMap;
    private final String message = NucleusPlugin.getNucleus().getMessageProvider().getMessageWithFormat("config.enabled", new String[0]);

    public StandardModule() {
        ModuleData md = this.getClass().getAnnotation(ModuleData.class);
        this.moduleId = md.id();
        this.moduleName = md.name();
        this.plugin = NucleusPlugin.getNucleus();
        this.commandsConfig = this.plugin.getCommandsConfig();
    }

    public void init(Map<String, List<String>> m) {
        this.objectTypesToClassListMap = m;
    }

    @Override
    public final void checkExternalDependencies() throws MissingDependencyException {
        if (this.getClass().isAnnotationPresent(ServerOnly.class) && !Nucleus.getNucleus().isServer()) {
            throw new MissingDependencyException("This module is server only and will not be loaded.");
        }
    }

    protected Map<String, Tokens.Translator> tokensToRegister() {
        return ImmutableMap.of();
    }

    @Override
    public Optional<AbstractConfigAdapter<?>> getConfigAdapter() {
        return Optional.empty();
    }

    @Override
    public final void preEnable() {
        try {
            this.loadRegistries();
            this.loadServices();
            this.performPreTasks();
            this.registerCommandInterceptors();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot enable module!", e);
        }
    }

    private void loadServices() throws Exception {
        Set servicesToLoad = this.objectTypesToClassListMap != null ? this.getClassesFromList("service") : this.getStreamForModule(ServiceBase.class).collect(Collectors.toSet());
        for (Class serviceClass : servicesToLoad) {
            this.registerService(serviceClass);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T extends ServiceBase> void registerService(Class<T> serviceClass) throws Exception {
        ServiceBase serviceImpl = (ServiceBase)this.getInstance(serviceClass);
        if (serviceImpl == null) {
            String error = "ERROR: Cannot instantiate " + serviceClass.getName();
            Nucleus.getNucleus().getLogger().error(error);
            throw new IllegalStateException(error);
        }
        APIService apiService = serviceClass.getAnnotation(APIService.class);
        if (apiService != null) {
            Class<?> apiInterface = apiService.value();
            if (!apiInterface.isInstance(serviceImpl)) {
                String error = "ERROR: " + apiInterface.getName() + " does not inherit from " + serviceClass.getName();
                Nucleus.getNucleus().getLogger().error(error);
                throw new IllegalStateException(error);
            }
            this.register(apiInterface, serviceClass, serviceImpl);
        } else {
            ReregisterService reregisterService = serviceClass.getAnnotation(ReregisterService.class);
            if (reregisterService != null) {
                Class<?> apiInterface = reregisterService.value();
                if (!apiInterface.isInstance(serviceImpl)) {
                    String error = "ERROR: " + apiInterface.getName() + " does not inherit from " + serviceClass.getName();
                    Nucleus.getNucleus().getLogger().error(error);
                    throw new IllegalStateException(error);
                }
                this.register(apiInterface, serviceClass, serviceImpl, true);
            } else {
                this.register(serviceClass, serviceImpl);
            }
        }
        if (serviceImpl instanceof Reloadable) {
            Reloadable reloadable = (Reloadable)((Object)serviceImpl);
            Nucleus.getNucleus().registerReloadable(reloadable);
            reloadable.onReload();
        }
        if (!(serviceImpl instanceof ContextCalculator)) return;
        try {
            serviceImpl.getClass().getMethod("matches", Context.class, Subject.class);
            ServiceChangeListener.getInstance().registerCalculator((ContextCalculator<Subject>)((ContextCalculator)serviceImpl));
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private void registerCommandInterceptors() throws Exception {
        RegisterCommandInterceptors annotation = this.getClass().getAnnotation(RegisterCommandInterceptors.class);
        if (annotation != null) {
            for (Class<? extends ICommandInterceptor> service : annotation.value()) {
                ICommandInterceptor impl;
                try {
                    impl = service.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    String error = "ERROR: Cannot instantiate ICommandInterceptor " + service.getName();
                    Nucleus.getNucleus().getLogger().error(error);
                    throw new IllegalStateException(error, e);
                }
                if (impl instanceof Reloadable) {
                    Reloadable reloadable = (Reloadable)((Object)impl);
                    Nucleus.getNucleus().registerReloadable(reloadable);
                    reloadable.onReload();
                }
                AbstractCommand.registerInterceptor(impl);
            }
        }
    }

    @Override
    public final void onEnable() {
        this.packageName = this.getClass().getPackage().getName() + ".";
        this.loadCommands();
        this.loadEvents();
        this.loadRunnables();
        this.loadUserPrefKeys();
        this.prepareAliasedCommands();
        try {
            this.performEnableTasks();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot enable module!", e);
        }
    }

    @Override
    public final void postEnable() {
        this.loadTokens();
        this.setPermissionPredicates();
        this.configTasks();
        try {
            this.performPostTasks();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot perform post enable on module!", e);
        }
    }

    protected void setPermissionPredicates() {
    }

    private void loadCommands() {
        Set<Class<AbstractCommand<?>>> cmds;
        if (this.objectTypesToClassListMap != null) {
            cmds = this.getClassesFromList("command");
        } else {
            cmds = new HashSet(this.performFilter(this.getStreamForModule(AbstractCommand.class).map(x -> x)).collect(Collectors.toSet()));
            this.performFilter(this.plugin.getModuleContainer().getLoadedClasses().stream().filter(x -> x.getPackage().getName().startsWith(this.packageName)).filter(x -> x.isAnnotationPresent(Scan.class)).flatMap(x -> Arrays.stream(x.getDeclaredClasses())).filter(AbstractCommand.class::isAssignableFrom).map(x -> x)).forEach(cmds::add);
        }
        Set<Class> commandBases = cmds.stream().filter(x -> {
            RegisterCommand rc = x.getAnnotation(RegisterCommand.class);
            return rc != null && rc.subcommandOf().equals(AbstractCommand.class);
        }).collect(Collectors.toSet());
        CommandBuilder builder = new CommandBuilder(this.plugin, cmds, this.moduleId, this.moduleName);
        commandBases.forEach(builder::buildCommand);
        try {
            this.commandsConfig.mergeDefaults(builder.getNodeToMerge());
            this.commandsConfig.save();
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Could not save defaults.");
            e.printStackTrace();
        }
    }

    private void prepareAliasedCommands() {
        ImmutableMap<String, String> toRegister = this.remapCommand();
        if (!toRegister.isEmpty()) {
            SimpleCommentedConfigurationNode ccn = SimpleCommentedConfigurationNode.root();
            for (Map.Entry map : toRegister.entrySet()) {
                if (this.commandsConfig.getCommandNode((String)map.getKey()).getNode(new Object[]{"enabled"}).getBoolean(true)) {
                    this.getServiceUnchecked(CommandRemapperService.class).addMapping(((String)map.getKey()).toLowerCase(), ((String)map.getValue()).toLowerCase());
                }
                ccn.getNode(new Object[]{map.getKey(), "enabled"}).setComment(this.message).setValue((Object)true);
            }
        }
    }

    private Stream<Class<? extends AbstractCommand<?>>> performFilter(Stream<Class<? extends AbstractCommand<?>>> stream) {
        return stream.filter(x -> x.isAnnotationPresent(RegisterCommand.class));
    }

    private void loadEvents() {
        Set listenersToLoad = this.objectTypesToClassListMap != null ? this.getClassesFromList("listener") : this.getStreamForModule(ListenerBase.class).collect(Collectors.toSet());
        Optional<DocGenCache> docGenCache = this.plugin.getDocGenCache();
        listenersToLoad.stream().map(x -> (ListenerBase)this.getInstance((Class)x, true)).filter(Objects::nonNull).forEach(c -> {
            c.getPermissions().forEach((k, v) -> this.plugin.getPermissionRegistry().registerOtherPermission((String)k, (PermissionInformation)v));
            docGenCache.ifPresent(x -> x.addPermissionDocs(this.moduleId, c.getPermissions()));
            if (c instanceof ListenerBase.Conditional) {
                Reloadable tae = () -> {
                    Sponge.getEventManager().unregisterListeners(c);
                    if (c instanceof Reloadable) {
                        ((Reloadable)((Object)c)).onReload();
                    }
                    if (((ListenerBase.Conditional)c).shouldEnable()) {
                        Sponge.getEventManager().registerListeners((Object)this.plugin, c);
                    }
                };
                this.plugin.registerReloadable(tae);
                try {
                    tae.onReload();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (c instanceof Reloadable) {
                this.plugin.registerReloadable((Reloadable)((Object)c));
                Sponge.getEventManager().registerListeners((Object)this.plugin, c);
            } else {
                Sponge.getEventManager().registerListeners((Object)this.plugin, c);
            }
        });
    }

    private void loadRunnables() {
        Set tasksToLoad = this.objectTypesToClassListMap != null ? this.getClassesFromList("runnable") : this.getStreamForModule(TaskBase.class).collect(Collectors.toSet());
        Optional<DocGenCache> docGenCache = this.plugin.getDocGenCache();
        tasksToLoad.stream().map(this::getInstance).filter(Objects::nonNull).forEach(c -> {
            c.getPermissions().forEach((k, v) -> this.plugin.getPermissionRegistry().registerOtherPermission((String)k, (PermissionInformation)v));
            docGenCache.ifPresent(x -> x.addPermissionDocs(this.moduleId, c.getPermissions()));
            Task.Builder tb = Sponge.getScheduler().createTaskBuilder().interval(c.interval().toMillis(), TimeUnit.MILLISECONDS);
            if (Nucleus.getNucleus().isServer()) {
                tb.execute((Consumer)c);
            } else {
                tb.execute(t -> {
                    if (Sponge.getGame().isServerAvailable()) {
                        c.accept(t);
                    }
                });
            }
            if (c.isAsync()) {
                tb.async();
            }
            tb.submit((Object)this.plugin);
            if (c instanceof Reloadable) {
                this.plugin.registerReloadable((Reloadable)((Object)c));
                try {
                    ((Reloadable)((Object)c)).onReload();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void loadTokens() {
        Map<String, Tokens.Translator> map = this.tokensToRegister();
        if (!map.isEmpty()) {
            map.forEach((k, t) -> {
                try {
                    if (!Tokens.INSTANCE.register((String)k, (Tokens.Translator)t, true)) {
                        Nucleus.getNucleus().getLogger().warn("Could not register primary token identifier " + k);
                    }
                }
                catch (IllegalArgumentException e) {
                    Nucleus.getNucleus().getLogger().warn("Could not register nucleus token identifier " + k);
                }
            });
        }
    }

    private void loadRegistries() {
        Set registries = this.objectTypesToClassListMap != null ? this.getClassesFromList("registry") : this.getStreamForModule(NucleusRegistryModule.class).collect(Collectors.toSet());
        for (Class r : registries) {
            NucleusRegistryModule instance = (NucleusRegistryModule)this.getInstance(r);
            try {
                instance.init();
            }
            catch (Exception e) {
                Nucleus.getNucleus().getLogger().error("Could not register registry " + r.getName(), (Throwable)e);
            }
        }
    }

    private void loadUserPrefKeys() {
        Set keyClasses = this.objectTypesToClassListMap != null ? this.getClassesFromList("prefkeys") : this.getStreamForModule(UserPrefKeys.class).collect(Collectors.toSet());
        if (!keyClasses.isEmpty()) {
            UserPreferenceService ups = Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(UserPreferenceService.class);
            for (Class r : keyClasses) {
                Arrays.stream(r.getFields()).filter(x -> Modifier.isStatic(x.getModifiers()) && NucleusUserPreferenceService.PreferenceKey.class.isAssignableFrom(x.getType())).forEach(x -> {
                    try {
                        PreferenceKey key = (PreferenceKey)x.get(null);
                        ups.register(key);
                    }
                    catch (IllegalAccessException e) {
                        Nucleus.getNucleus().getLogger().error("Could not register " + x.getName() + " in the User Preference Service", (Throwable)e);
                    }
                });
            }
        }
    }

    private <T> Stream<Class<? extends T>> getStreamForModule(Class<T> assignableClass) {
        return Nucleus.getNucleus().getModuleContainer().getLoadedClasses().stream().filter(assignableClass::isAssignableFrom).filter(x -> x.getPackage().getName().startsWith(this.packageName)).filter(x -> !Modifier.isAbstract(x.getModifiers()) && !Modifier.isInterface(x.getModifiers())).filter(this::checkPlatform).map(x -> x);
    }

    protected void performPreTasks() throws Exception {
    }

    protected void performEnableTasks() throws Exception {
    }

    protected void performPostTasks() {
    }

    void configTasks() {
    }

    protected ImmutableMap<String, String> remapCommand() {
        return ImmutableMap.of();
    }

    private <T> T getInstance(Class<T> clazz) {
        return this.getInstance(clazz, false);
    }

    private <T> T getInstance(Class<T> clazz, boolean checkMethods) {
        try {
            RequireExistenceOf[] v = (RequireExistenceOf[])clazz.getAnnotationsByType(RequireExistenceOf.class);
            if (v.length > 0) {
                try {
                    for (RequireExistenceOf r : v) {
                        String toFind = r.value();
                        String[] a = toFind.contains("#") ? toFind.split("#", 2) : new String[]{toFind};
                        Class<?> c = Class.forName(a[0]);
                        if (a.length != 2) continue;
                        Method[] methods = c.getDeclaredMethods();
                        boolean methodFound = false;
                        for (Method m : methods) {
                            if (!m.getName().equals(a[1])) continue;
                            methodFound = true;
                            break;
                        }
                        if (methodFound) continue;
                        if (r.showError()) {
                            throw new RuntimeException();
                        }
                        return null;
                    }
                }
                catch (ClassNotFoundException | NoClassDefFoundError | RuntimeException e) {
                    this.plugin.getLogger().warn(NucleusPlugin.getNucleus().getMessageProvider().getMessageWithFormat("startup.injectablenotloaded", clazz.getName()));
                    return null;
                }
            }
            if (checkMethods) {
                clazz.getDeclaredMethods();
            }
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException | NoClassDefFoundError | RuntimeException e) {
            if (clazz.isAnnotationPresent(SkipOnError.class)) {
                this.plugin.getLogger().warn(NucleusPlugin.getNucleus().getMessageProvider().getMessageWithFormat("startup.injectablenotloaded", clazz.getName()));
                return null;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private <T extends Class<?>> Optional<T> checkPlatformOpt(T clazz) {
        if (this.checkPlatform(clazz)) {
            return Optional.of(clazz);
        }
        return Optional.empty();
    }

    private <T extends Class<?>> boolean checkPlatform(T clazz) {
        if (clazz.isAnnotationPresent(RequiresPlatform.class)) {
            String platformId = Sponge.getPlatform().getContainer(Platform.Component.GAME).getId();
            boolean loadable = Arrays.stream(clazz.getAnnotation(RequiresPlatform.class).value()).anyMatch(platformId::equalsIgnoreCase);
            if (!loadable) {
                this.plugin.getLogger().warn("Not loading /" + clazz.getSimpleName() + ": platform " + platformId + " is not supported.");
                return false;
            }
        }
        return true;
    }

    protected final void createSeenModule(BiFunction<CommandSource, User, Collection<Text>> function) {
        this.createSeenModule((String)null, function);
    }

    protected final void createSeenModule(@Nullable Class<? extends AbstractCommand> permissionClass, BiFunction<CommandSource, User, Collection<Text>> function) {
        CommandPermissionHandler permissionHandler = this.plugin.getPermissionRegistry().getPermissionsForNucleusCommand(permissionClass);
        this.createSeenModule(permissionHandler == null ? null : permissionHandler.getBase(), function);
    }

    protected void createSeenModule(@Nullable String permission, BiFunction<CommandSource, User, Collection<Text>> function) {
        this.plugin.getInternalServiceManager().getService(SeenHandler.class).ifPresent(x -> x.register(this.plugin, this.getClass().getAnnotation(ModuleData.class).name(), new BasicSeenInformationProvider(permission, function)));
    }

    protected final <I, S extends I> void register(Class<S> impl) throws IllegalAccessException, InstantiationException {
        Nucleus.getNucleus().getInternalServiceManager().registerService(impl, impl.newInstance());
    }

    protected final <I, S extends I> void register(Class<I> api, Class<S> impl) throws IllegalAccessException, InstantiationException {
        S object = impl.newInstance();
        Sponge.getServiceManager().setProvider((Object)Nucleus.getNucleus(), api, object);
        Nucleus.getNucleus().getInternalServiceManager().registerService(api, object);
        this.register(impl, object);
    }

    protected final <I, S extends I> void register(Class<S> impl, S object) {
        Nucleus.getNucleus().getInternalServiceManager().registerService(impl, object);
    }

    protected final <I, S extends I> void register(Class<I> internalApi, Class<S> impl, S object, boolean remap) {
        this.register(impl, object);
        Nucleus.getNucleus().getInternalServiceManager().registerService(internalApi, object, remap);
    }

    protected final <I, S extends I> void register(Class<I> api, Class<S> impl, S object) {
        Sponge.getServiceManager().setProvider((Object)Nucleus.getNucleus(), api, object);
        Nucleus.getNucleus().getInternalServiceManager().registerService(api, object);
        this.register(impl, object);
    }

    private <T> Set<Class<? extends T>> getClassesFromList(String key) {
        List<String> list = this.objectTypesToClassListMap.get(key);
        if (list == null) {
            return new HashSet<Class<? extends T>>();
        }
        HashSet<Class<? extends T>> classes = new HashSet<Class<? extends T>>();
        for (String s : list) {
            try {
                this.checkPlatformOpt(Class.forName(s)).ifPresent(classes::add);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return classes;
    }
}

