/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.internal.text;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.text.NucleusTextTemplate;
import io.github.nucleuspowered.nucleus.internal.text.NucleusTextTemplateFactory;
import io.github.nucleuspowered.nucleus.internal.text.TextParsingUtils;
import io.github.nucleuspowered.nucleus.util.JsonConfigurateStringHelper;
import io.github.nucleuspowered.nucleus.util.Tuples;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.SimpleConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextRepresentable;
import org.spongepowered.api.text.TextTemplate;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
public abstract class NucleusTextTemplateImpl
implements NucleusTextTemplate {
    private static final Map<String, Object> emptyVariables = Maps.newHashMap();
    @Nullable
    private final Text prefix;
    @Nullable
    private final Text suffix;
    private final String representation;
    private final TextTemplate textTemplate;
    private final Map<String, Function<CommandSource, Text>> tokenMap = Maps.newHashMap();

    public NucleusTextTemplateImpl(String representation, @Nullable Text prefix, @Nullable Text suffix) {
        this.representation = representation;
        Tuple<TextTemplate, Map<String, Function<CommandSource, Text>>> t = this.parse(representation);
        this.textTemplate = (TextTemplate)t.getFirst();
        this.tokenMap.putAll((Map)t.getSecond());
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public NucleusTextTemplateImpl(String representation) {
        this(representation, null, null);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Optional<Text> getPrefix() {
        return Optional.ofNullable(this.prefix);
    }

    @Override
    public Optional<Text> getSuffix() {
        return Optional.ofNullable(this.suffix);
    }

    public String getRepresentation() {
        return this.representation;
    }

    @Override
    public TextTemplate getTextTemplate() {
        return this.textTemplate;
    }

    abstract Tuple<TextTemplate, Map<String, Function<CommandSource, Text>>> parse(String var1);

    @Override
    public boolean containsTokens() {
        return !this.textTemplate.getArguments().isEmpty();
    }

    @Override
    public Text getForCommandSource(CommandSource source, @Nullable Map<String, Function<CommandSource, Optional<Text>>> tokensArray, @Nullable Map<String, Object> variables) {
        Text finalText;
        Map<String, Object> variables2 = variables == null ? emptyVariables : variables;
        Map tokens = this.textTemplate.getArguments();
        HashMap finalArgs = Maps.newHashMap();
        tokens.forEach((k, v) -> {
            String key = k.toLowerCase();
            Text t = this.tokenMap.containsKey(key) ? this.tokenMap.get(key).apply(source) : (tokensArray != null && tokensArray.containsKey(key) ? (Text)((Optional)((Function)tokensArray.get(key)).apply(source)).orElse(null) : (Text)Nucleus.getNucleus().getMessageTokenService().parseToken(key, source, variables2).orElse(null));
            if (t != null) {
                finalArgs.put(k, t);
            }
        });
        Text.Builder builder = Text.builder();
        TextParsingUtils.StyleTuple st = null;
        if (this.prefix != null) {
            builder.append(new Text[]{this.prefix});
            st = TextParsingUtils.getLastColourAndStyle((TextRepresentable)this.prefix, null);
        }
        if (!(finalText = this.textTemplate.apply((Map)finalArgs).build()).isEmpty()) {
            if (st == null) {
                builder.append(new Text[]{finalText});
            } else {
                builder.append(new Text[]{Text.builder().color(st.colour).style(new TextStyle[]{st.style}).append(new Text[]{finalText}).build()});
            }
        }
        if (this.suffix != null) {
            builder.append(new Text[]{this.suffix});
        }
        return builder.build();
    }

    public Text toText() {
        return this.textTemplate.toText();
    }

    public static class Empty
    extends NucleusTextTemplateImpl {
        public static final NucleusTextTemplateImpl INSTANCE = new Empty();

        private Empty() {
            super("");
        }

        @Override
        Tuple<TextTemplate, Map<String, Function<CommandSource, Text>>> parse(String parser) {
            return Tuple.of((Object)TextTemplate.EMPTY, (Object)Maps.newHashMap());
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }

    static class Json
    extends NucleusTextTemplateImpl {
        @Nullable
        private static TypeSerializer<TextTemplate> textTemplateTypeSerializer = null;

        private static TypeSerializer<TextTemplate> getSerialiser() {
            if (textTemplateTypeSerializer == null) {
                textTemplateTypeSerializer = ConfigurationOptions.defaults().getSerializers().get(TypeToken.of(TextTemplate.class));
            }
            return textTemplateTypeSerializer;
        }

        Json(String representation, @Nullable Text prefix, @Nullable Text suffix) {
            super(representation, prefix, suffix);
        }

        Json(String representation) {
            super(representation);
        }

        Json(TextTemplate textTemplate) {
            super(JsonConfigurateStringHelper.getJsonStringFrom(textTemplate));
        }

        @Override
        Tuple<TextTemplate, Map<String, Function<CommandSource, Text>>> parse(String parser) {
            try {
                return Tuple.of((Object)Json.getSerialiser().deserialize(TypeToken.of(TextTemplate.class), JsonConfigurateStringHelper.getNodeFromJson(parser).orElseGet(() -> SimpleConfigurationNode.root().setValue((Object)parser))), (Object)Maps.newHashMap());
            }
            catch (ObjectMappingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class Ampersand
    extends NucleusTextTemplateImpl {
        private static final Pattern pattern = Pattern.compile("(?<url>\\[[^\\[]+]\\(/[^)]*?)?(?<match>\\{\\{(?!subject)(?<name>[^\\s{}]+)}})(?<urltwo>[^(]*?\\))?");

        Ampersand(String representation) {
            super(representation);
        }

        Ampersand(String representation, @Nullable Text prefix, @Nullable Text suffix) {
            super(representation, prefix, suffix);
        }

        @Override
        Tuple<TextTemplate, Map<String, Function<CommandSource, Text>>> parse(String input) {
            String string = NucleusTextTemplateFactory.INSTANCE.performReplacements(input);
            Matcher mat = pattern.matcher(string);
            ArrayList map = Lists.newArrayList();
            ArrayList s = Lists.newArrayList((Object[])pattern.split(string));
            int index = 0;
            while (mat.find()) {
                if (mat.group("url") != null && mat.group("urltwo") != null) {
                    String toUpdate = (String)s.get(index);
                    toUpdate = toUpdate + mat.group();
                    if (s.size() >= index + 1) continue;
                    toUpdate = toUpdate + (String)s.get(index + 1);
                    s.remove(index + 1);
                    s.set(index, toUpdate);
                    continue;
                }
                String out = mat.group("url");
                if (out != null) {
                    if (s.isEmpty()) {
                        s.add(out);
                    } else {
                        s.set(index, (String)s.get(index) + out);
                    }
                }
                ++index;
                out = mat.group("urltwo");
                if (out != null) {
                    if (s.size() <= index) {
                        s.add(out);
                    } else {
                        s.set(index, out + (String)s.get(index));
                    }
                }
                map.add(mat.group("name").toLowerCase());
            }
            ArrayDeque<Object> texts = new ArrayDeque<Object>();
            HashMap tokens = Maps.newHashMap();
            TextParsingUtils cu = Nucleus.getNucleus().getTextParsingUtils();
            if (s.size() > 0) {
                cu.createTextTemplateFragmentWithLinks((String)s.get(0)).mapIfPresent(texts::addAll, tokens::putAll);
            }
            for (int i = 0; i < map.size(); ++i) {
                TextTemplate.Arg.Builder arg = TextTemplate.arg((String)((String)map.get(i))).optional();
                TextRepresentable r = (TextRepresentable)texts.peekLast();
                TextParsingUtils.StyleTuple style = null;
                if (r != null) {
                    style = TextParsingUtils.getLastColourAndStyle(r, null);
                    style.applyTo(st -> arg.color(st.colour).style(st.style));
                }
                texts.add(arg.build());
                if (s.size() <= i + 1) continue;
                Tuples.NullableTuple<List<TextRepresentable>, Map<String, Function<CommandSource, Text>>> tt = cu.createTextTemplateFragmentWithLinks((String)s.get(i + 1));
                if (style != null && tt.getFirst().isPresent()) {
                    texts.push(style.getTextOf());
                }
                cu.createTextTemplateFragmentWithLinks((String)s.get(i + 1)).mapIfPresent(texts::addAll, tokens::putAll);
            }
            return Tuple.of((Object)TextTemplate.of((Object[])texts.toArray(new Object[0])), (Object)tokens);
        }
    }
}

