/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.internal.text;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.service.NucleusMessageTokenService;
import io.github.nucleuspowered.nucleus.modules.core.datamodules.UniqueUserCountTransientModule;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.command.source.RemoteSource;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.api.world.World;

public final class Tokens
implements NucleusMessageTokenService.TokenParser {
    public static final Tokens INSTANCE = new Tokens();
    private final Map<String, Translator> translatorMap = Maps.newHashMap();

    private Tokens() {
        this.translatorMap.put("name", (p, v, m) -> Optional.of(Nucleus.getNucleus().getTextParsingUtils().addCommandToName(Tokens.getFromVariableIfExists(p, v, m))));
        this.translatorMap.put("player", (p, v, m) -> Optional.of(Nucleus.getNucleus().getTextParsingUtils().addCommandToDisplayName(Tokens.getFromVariableIfExists(p, v, m))));
        this.translatorMap.put("playername", (p, v, m) -> Optional.of(Nucleus.getNucleus().getTextParsingUtils().addCommandToDisplayName(Tokens.getFromVariableIfExists(p, v, m))));
        this.translatorMap.put("prefix", (p, v, m) -> Tokens.getTextFromOption(Tokens.getFromVariableIfExists(p, v, m), "prefix"));
        this.translatorMap.put("suffix", (p, v, m) -> Tokens.getTextFromOption(Tokens.getFromVariableIfExists(p, v, m), "suffix"));
        this.translatorMap.put("playerdisplayname", (p, v, m) -> Optional.of(Nucleus.getNucleus().getTextParsingUtils().addCommandToDisplayName(Tokens.getFromVariableIfExists(p, v, m))));
        this.translatorMap.put("displayname", (p, v, m) -> Optional.of(Nucleus.getNucleus().getTextParsingUtils().addCommandToDisplayName(Tokens.getFromVariableIfExists(p, v, m))));
        this.translatorMap.put("maxplayers", (p, v, m) -> Optional.of(Text.of((Object[])new Object[]{Sponge.getServer().getMaxPlayers()})));
        this.translatorMap.put("onlineplayers", (p, v, m) -> Optional.of(Text.of((Object[])new Object[]{Sponge.getServer().getOnlinePlayers().size()})));
        this.translatorMap.put("currentworld", (p, v, m) -> Optional.of(Text.of((String)Tokens.getWorld(Tokens.getFromVariableIfExists(p, v, m)).getName())));
        this.translatorMap.put("time", (p, v, m) -> Optional.of(Text.of((String)Util.getTimeFromTicks(Tokens.getWorld(Tokens.getFromVariableIfExists(p, v, m)).getProperties().getWorldTime()))));
        this.translatorMap.put("uniquevisitor", (p, v, m) -> Optional.of(Text.of((Object[])new Object[]{Nucleus.getNucleus().getGeneralService().getTransient(UniqueUserCountTransientModule.class).getUniqueUserCount()})));
        this.translatorMap.put("ipaddress", (p, v, m) -> Optional.of(Text.of((String)(p instanceof RemoteSource ? ((RemoteSource)p).getConnection().getAddress().getAddress().toString() : "localhost"))));
        this.translatorMap.put("subject", (p, v, m) -> Optional.of(Text.of((String)(p instanceof ConsoleSource ? "-" : p.getName()))));
    }

    @Override
    @Nonnull
    public Optional<Text> parse(String tokenInput, CommandSource source, Map<String, Object> variables) {
        String[] split = tokenInput.split("\\|", 2);
        String var = "";
        if (split.length == 2) {
            var = split[1];
        }
        return this.translatorMap.getOrDefault(split[0].toLowerCase(), (p, v, m) -> Optional.empty()).get(source, var, variables);
    }

    public Set<String> getTokenNames() {
        return Sets.newHashSet(this.translatorMap.keySet());
    }

    public boolean register(String name, Translator translator, boolean primary) throws IllegalArgumentException {
        String nameLower = name.toLowerCase();
        if (this.translatorMap.containsKey(nameLower)) {
            throw new IllegalArgumentException("Cannot register this");
        }
        this.translatorMap.put(nameLower, translator);
        return !primary || Nucleus.getNucleus().getMessageTokenService().registerPrimaryToken(nameLower, Nucleus.getNucleus().getPluginContainer(), nameLower);
    }

    private static CommandSource getFromVariableIfExists(CommandSource source, String v, Map<String, Object> m) {
        if (m.containsKey(v) && m.get(v) instanceof CommandSource) {
            return (CommandSource)m.get(v);
        }
        return source;
    }

    private static World getWorld(CommandSource p) {
        World world = p instanceof Locatable ? ((Locatable)p).getWorld() : (World)Sponge.getServer().getWorld(Sponge.getServer().getDefaultWorldName()).get();
        return world;
    }

    private static Optional<Text> getTextFromOption(CommandSource cs, String option) {
        return Util.getOptionFromSubject((Subject)cs, option).map(x -> x.isEmpty() ? null : TextSerializers.FORMATTING_CODE.deserialize(x));
    }

    public static abstract class TrueFalseVariableTranslator
    implements Translator {
        protected abstract Optional<Text> getDefault();

        protected abstract boolean condition(CommandSource var1);

        @Override
        public final Optional<Text> get(CommandSource source, String variableString, Map<String, Object> variables) {
            boolean res = this.condition(source);
            if (variableString != null && !variableString.isEmpty()) {
                if (variableString.contains("|")) {
                    String[] s = variableString.split("\\|", 2);
                    return Optional.of(res ? TextSerializers.FORMATTING_CODE.deserialize(s[0]) : TextSerializers.FORMATTING_CODE.deserialize(s[1]));
                }
                return Optional.ofNullable(res ? TextSerializers.FORMATTING_CODE.deserialize(variableString) : null);
            }
            return res ? this.getDefault() : Optional.empty();
        }
    }

    @FunctionalInterface
    public static interface Translator {
        public Optional<Text> get(CommandSource var1, String var2, Map<String, Object> var3);
    }
}

