/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.admin.listener;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.interfaces.ListenerBase;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.ExperienceOrb;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.entity.DestructEntityEvent;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.entity.living.humanoid.player.RespawnPlayerEvent;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.util.Tristate;

public class ExperienceListener
implements ListenerBase {
    private final Map<UUID, Integer> deadExpPlayers = new HashMap<UUID, Integer>();
    private static final String KEEP_EXP_PERMISSION = "nucleus.exp.keepondeath";

    @Override
    public Map<String, PermissionInformation> getPermissions() {
        HashMap<String, PermissionInformation> map = new HashMap<String, PermissionInformation>();
        map.put(KEEP_EXP_PERMISSION, PermissionInformation.getWithTranslation("permission.enchantment.keepxp", SuggestedLevel.NONE));
        return map;
    }

    @Listener(order=Order.POST)
    public void onPlayerDeathMonitor(DestructEntityEvent.Death deathEvent, @Getter(value="getTargetEntity") Player player) {
        Tristate tristate = player.getPermissionValue(player.getActiveContexts(), KEEP_EXP_PERMISSION);
        if (tristate == Tristate.TRUE) {
            int exp = player.get(Keys.TOTAL_EXPERIENCE).orElse(0);
            this.deadExpPlayers.put(player.getUniqueId(), exp);
        } else if (tristate == Tristate.FALSE) {
            this.deadExpPlayers.put(player.getUniqueId(), 0);
        }
    }

    @Listener
    public void preventExperienceDroppingOrb(SpawnEntityEvent event, @Root Player player) {
        if (this.deadExpPlayers.getOrDefault(player.getUniqueId(), 0) > 0) {
            event.filterEntities(entity -> !(entity instanceof ExperienceOrb));
        }
    }

    @Listener
    public void onPlayerRespawn(RespawnPlayerEvent event, @Getter(value="getTargetEntity") Player player) {
        this.applyExperience(player);
    }

    @Listener
    public void onPlayerJoin(ClientConnectionEvent.Join event, @Getter(value="getTargetEntity") Player player) {
        this.applyExperience(player);
    }

    private void applyExperience(Player player) {
        if (this.deadExpPlayers.containsKey(player.getUniqueId())) {
            int e = this.deadExpPlayers.get(player.getUniqueId());
            Task.builder().delayTicks(1L).execute(() -> player.offer(Keys.TOTAL_EXPERIENCE, (Object)e)).submit((Object)Nucleus.getNucleus());
            this.deadExpPlayers.remove(player.getUniqueId());
        }
    }
}

