/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.afk.services;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.service.NucleusAFKService;
import io.github.nucleuspowered.nucleus.api.util.NoExceptionAutoClosable;
import io.github.nucleuspowered.nucleus.internal.CommandPermissionHandler;
import io.github.nucleuspowered.nucleus.internal.annotations.APIService;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.interfaces.ServiceBase;
import io.github.nucleuspowered.nucleus.internal.permissions.ServiceChangeListener;
import io.github.nucleuspowered.nucleus.internal.text.NucleusTextTemplateImpl;
import io.github.nucleuspowered.nucleus.internal.traits.MessageProviderTrait;
import io.github.nucleuspowered.nucleus.modules.afk.commands.AFKCommand;
import io.github.nucleuspowered.nucleus.modules.afk.config.AFKConfig;
import io.github.nucleuspowered.nucleus.modules.afk.config.AFKConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.afk.events.AFKEvents;
import io.github.nucleuspowered.nucleus.util.CauseStackHelper;
import io.github.nucleuspowered.nucleus.util.Tuples;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.chat.ChatTypes;
import org.spongepowered.api.util.Identifiable;

@APIService(value=NucleusAFKService.class)
public class AFKHandler
implements NucleusAFKService,
Reloadable,
ServiceBase,
MessageProviderTrait {
    private final Map<UUID, AFKData> data = Maps.newConcurrentMap();
    private final AFKConfigAdapter afkConfigAdapter;
    private final CommandPermissionHandler afkPermissionHandler;
    private AFKConfig config;
    @GuardedBy(value="lock")
    private final Set<UUID> activity = Sets.newHashSet();
    @GuardedBy(value="lock2")
    private final Multimap<UUID, UUID> disabledTracking = HashMultimap.create();
    private final Object lock = new Object();
    private final Object lock2 = new Object();
    private final String exempttoggle = "exempt.toggle";
    private final String exemptkick = "exempt.kick";
    private final String afkOption = "nucleus.afk.toggletime";
    private final String afkKickOption = "nucleus.afk.kicktime";

    public AFKHandler() {
        this.afkPermissionHandler = Nucleus.getNucleus().getPermissionRegistry().getPermissionsForNucleusCommand(AFKCommand.class);
        this.afkConfigAdapter = Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(AFKConfigAdapter.class);
    }

    public void stageUserActivityUpdate(Player player) {
        if (player.isOnline()) {
            this.stageUserActivityUpdate(player.getUniqueId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stageUserActivityUpdate(UUID uuid) {
        Object object = this.lock;
        synchronized (object) {
            Object object2 = this.lock2;
            synchronized (object2) {
                if (this.disabledTracking.containsKey((Object)uuid)) {
                    return;
                }
            }
            this.activity.add(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTick() {
        Object object = this.lock;
        synchronized (object) {
            this.activity.forEach(u -> this.data.compute((UUID)u, (uuid, afkData) -> afkData == null ? new AFKData((UUID)uuid) : this.updateActivity((UUID)uuid, (AFKData)afkData)));
            this.activity.clear();
        }
        List uuidList = Sponge.getServer().getOnlinePlayers().stream().map(Identifiable::getUniqueId).collect(Collectors.toList());
        Set<Map.Entry<UUID, AFKData>> entries = this.data.entrySet();
        entries.removeIf(refactor -> !uuidList.contains(refactor.getKey()));
        entries.stream().filter(x -> !((AFKData)x.getValue()).cacheValid).forEach(x -> ((AFKData)x.getValue()).updateFromPermissions());
        long now = System.currentTimeMillis();
        entries.stream().filter(x -> ((AFKData)x.getValue()).isKnownAfk && !((AFKData)x.getValue()).willKick && ((AFKData)x.getValue()).timeToKick > 0L).forEach(e -> {
            if (now - ((AFKData)e.getValue()).lastActivityTime > ((AFKData)e.getValue()).timeToKick) {
                ((AFKData)e.getValue()).willKick = true;
                NucleusTextTemplateImpl message = this.config.getMessages().getKickMessage();
                NucleusTextTemplateImpl t = message == null || message.isEmpty() ? Nucleus.getNucleus().getMessageProvider().getTextMessageWithTextFormat("afk.kickreason", new Text[0]) : message;
                NucleusTextTemplateImpl messageToServer = this.config.getMessages().getOnKick();
                Sponge.getServer().getPlayer((UUID)e.getKey()).ifPresent(player -> {
                    MessageChannel mc = this.config.isBroadcastOnKick() ? MessageChannel.TO_ALL : MessageChannel.permission((String)this.afkPermissionHandler.getPermissionWithSuffix("notify"));
                    AFKEvents.Kick events = new AFKEvents.Kick((Player)player, messageToServer.getForCommandSource((CommandSource)player), mc);
                    if (Sponge.getEventManager().post((Event)events)) {
                        return;
                    }
                    Text toSend = t instanceof NucleusTextTemplateImpl ? ((NucleusTextTemplateImpl)t).getForCommandSource((CommandSource)player) : t.toText();
                    Sponge.getScheduler().createSyncExecutor((Object)Nucleus.getNucleus()).execute(() -> player.kick(toSend));
                    events.getMessage().ifPresent(m -> events.getChannel().send(player, m, ChatTypes.SYSTEM));
                });
            }
        });
        entries.stream().filter(x -> !((AFKData)x.getValue()).isKnownAfk && ((AFKData)x.getValue()).timeToAfk > 0L).forEach(e -> {
            if (now - ((AFKData)e.getValue()).lastActivityTime > ((AFKData)e.getValue()).timeToAfk) {
                Sponge.getServer().getPlayer((UUID)e.getKey()).ifPresent(this::setAfkInternal);
            }
        });
    }

    public void invalidateAfkCache() {
        this.data.forEach((k, v) -> ((AFKData)v).cacheValid = false);
    }

    public boolean isAFK(UUID uuid) {
        return this.data.containsKey(uuid) && this.data.get((Object)uuid).isKnownAfk;
    }

    public boolean setAfkInternal(Player player) {
        return this.setAfkInternal(player, CauseStackHelper.createCause(player), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setAfkInternal(Player player, Cause cause, boolean force) {
        if (!player.isOnline()) {
            return false;
        }
        UUID uuid = player.getUniqueId();
        AFKData a = this.data.compute(uuid, (u, afkData) -> afkData == null ? new AFKData((UUID)u) : afkData);
        if (force) {
            a.isKnownAfk = false;
        } else if (a.isKnownAfk) {
            return false;
        }
        if (a.canGoAfk()) {
            Object object = this.lock;
            synchronized (object) {
                this.activity.remove(uuid);
            }
            Tuples.NullableTuple<Text, MessageChannel> ttmc = this.getAFKMessage(player, true);
            AFKEvents.To event = new AFKEvents.To(player, ttmc.getFirstUnwrapped(), ttmc.getSecondUnwrapped(), cause);
            Sponge.getEventManager().post((Event)event);
            this.actionEvent(event, "command.afk.to.nobc", "command.afk.to.console");
            a.isKnownAfk = true;
            return true;
        }
        return false;
    }

    @Override
    public void onReload() {
        this.config = (AFKConfig)this.afkConfigAdapter.getNodeOrDefault();
    }

    private AFKData updateActivity(UUID uuid, AFKData data) {
        ArrayList lo = Lists.newArrayList();
        Sponge.getServer().getPlayer(uuid).ifPresent(lo::add);
        return this.updateActivity(uuid, data, CauseStackHelper.createCause(lo));
    }

    private AFKData updateActivity(UUID uuid, AFKData data, Cause cause) {
        data.lastActivityTime = System.currentTimeMillis();
        if (data.isKnownAfk) {
            data.isKnownAfk = false;
            data.willKick = false;
            Sponge.getServer().getPlayer(uuid).ifPresent(x -> {
                Tuples.NullableTuple<Text, MessageChannel> ttmc = this.getAFKMessage((Player)x, false);
                AFKEvents.From event = new AFKEvents.From((Player)x, ttmc.getFirstUnwrapped(), ttmc.getSecondUnwrapped(), cause);
                Sponge.getEventManager().post((Event)event);
                this.actionEvent(event, "command.afk.from.nobc", "command.afk.from.console");
            });
        }
        return data;
    }

    private void actionEvent(AFKEvents event, String key, @Nullable String consoleKey) {
        Optional<Text> message = event.getMessage().filter(x -> !x.isEmpty() && !x.toPlain().matches("^\\s*$"));
        if (message.isPresent()) {
            event.getChannel().send((Object)event.getTargetEntity(), message.get(), ChatTypes.SYSTEM);
        } else {
            this.sendMessageTo((CommandSource)event.getTargetEntity(), key);
            if (consoleKey != null) {
                this.sendMessageTo((CommandSource)Sponge.getServer().getConsole(), consoleKey, event.getTargetEntity().getName());
            }
        }
    }

    private Tuples.NullableTuple<Text, MessageChannel> getAFKMessage(Player player, boolean isAfk) {
        if (this.config.isBroadcastAfkOnVanish() || !player.get(Keys.VANISH).orElse(false).booleanValue()) {
            NucleusTextTemplateImpl template = isAfk ? this.config.getMessages().getAfkMessage() : this.config.getMessages().getReturnAfkMessage();
            return Tuples.ofNullable(template.getForCommandSource((CommandSource)player), MessageChannel.TO_ALL);
        }
        return Tuples.ofNullable(null, MessageChannel.TO_NONE);
    }

    @Override
    public boolean canGoAFK(User user) {
        return this.getData(user.getUniqueId()).canGoAfk();
    }

    @Override
    public boolean isAFK(Player player) {
        return this.isAFK(player.getUniqueId());
    }

    @Override
    public boolean setAFK(Cause cause, Player player, boolean isAfk) {
        Preconditions.checkArgument((boolean)(cause.root() instanceof PluginContainer), (Object)"The root object MUST be a plugin container.");
        AFKData data = this.data.computeIfAbsent(player.getUniqueId(), x$0 -> new AFKData((UUID)x$0));
        if (data.isKnownAfk == isAfk) {
            return false;
        }
        if (isAfk) {
            return this.setAfkInternal(player, cause, false);
        }
        return !this.updateActivity((UUID)player.getUniqueId(), (AFKData)data, (Cause)cause).isKnownAfk;
    }

    @Override
    public boolean canBeKicked(User user) {
        return this.getData(user.getUniqueId()).canBeKicked();
    }

    @Override
    public Instant lastActivity(Player player) {
        return Instant.ofEpochMilli(this.data.computeIfAbsent(player.getUniqueId(), x$0 -> new AFKData((UUID)x$0)).lastActivityTime);
    }

    @Override
    public Optional<Duration> timeForInactivity(User user) {
        AFKData data = this.getData(user.getUniqueId());
        if (data.canGoAfk()) {
            return Optional.of(Duration.ofMillis(data.timeToAfk));
        }
        return Optional.empty();
    }

    @Override
    public Optional<Duration> timeForKick(User user) {
        AFKData data = this.getData(user.getUniqueId());
        if (data.canBeKicked()) {
            return Optional.of(Duration.ofMillis(data.timeToKick));
        }
        return Optional.empty();
    }

    @Override
    public void invalidateCachedPermissions() {
        this.invalidateAfkCache();
    }

    @Override
    public void updateActivityForUser(Player player) {
        this.stageUserActivityUpdate(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NoExceptionAutoClosable disableTrackingForPlayer(Player player, int ticks) {
        Task n = Task.builder().execute(t -> {
            Object object = this.lock2;
            synchronized (object) {
                this.disabledTracking.remove((Object)player.getUniqueId(), (Object)t.getUniqueId());
            }
        }).delayTicks((long)ticks).submit((Object)Nucleus.getNucleus());
        Object object = this.lock2;
        synchronized (object) {
            this.disabledTracking.put((Object)player.getUniqueId(), (Object)n.getUniqueId());
        }
        return () -> {
            n.cancel();
            n.getConsumer().accept(n);
        };
    }

    private AFKData getData(UUID uuid) {
        AFKData data = this.data.get(uuid);
        if (data == null) {
            data = new AFKData(uuid, false);
        }
        return data;
    }

    @Override
    public Collection<Player> getAfk() {
        return this.getAfk(x -> true);
    }

    public Collection<Player> getAfk(Predicate<Player> filter) {
        return this.data.entrySet().stream().filter(x -> ((AFKData)x.getValue()).isKnownAfk).map(x -> Sponge.getServer().getPlayer((UUID)x.getKey()).orElse(null)).filter(Objects::nonNull).filter(filter).collect(Collectors.toList());
    }

    class AFKData {
        private final UUID uuid;
        private long lastActivityTime = System.currentTimeMillis();
        boolean isKnownAfk = false;
        private boolean willKick = false;
        private boolean cacheValid = false;
        private long timeToAfk = -1L;
        private long timeToKick = -1L;

        private AFKData(UUID uuid) {
            this(uuid, true);
        }

        private AFKData(UUID uuid, boolean permCheck) {
            this.uuid = uuid;
            if (permCheck) {
                this.updateFromPermissions();
            }
        }

        private boolean canGoAfk() {
            this.cacheValid = false;
            this.updateFromPermissions();
            return this.timeToAfk > 0L;
        }

        private boolean canBeKicked() {
            this.cacheValid = false;
            this.updateFromPermissions();
            return this.timeToKick > 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateFromPermissions() {
            AFKData aFKData = this;
            synchronized (aFKData) {
                if (!this.cacheValid) {
                    Sponge.getServer().getPlayer(this.uuid).ifPresent(x -> {
                        this.timeToAfk = !ServiceChangeListener.isOpOnly() && AFKHandler.this.afkPermissionHandler.testSuffix((Subject)x, "exempt.toggle") ? -1L : Util.getPositiveLongOptionFromSubject((Subject)x, "nucleus.afk.toggletime").orElseGet(() -> AFKHandler.this.config.getAfkTime()) * 1000L;
                        this.timeToKick = AFKHandler.this.afkPermissionHandler.testSuffix((Subject)x, "exempt.kick") ? -1L : Util.getPositiveLongOptionFromSubject((Subject)x, "nucleus.afk.kicktime").orElseGet(() -> AFKHandler.this.config.getAfkTimeToKick()) * 1000L;
                        this.cacheValid = true;
                    });
                }
            }
        }
    }
}

