/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.back.commands;

import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.internal.teleport.NucleusTeleportHandler;
import io.github.nucleuspowered.nucleus.modules.back.config.BackConfig;
import io.github.nucleuspowered.nucleus.modules.back.config.BackConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.back.services.BackHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.World;

@Permissions
@RegisterCommand(value={"back", "return"})
@EssentialsEquivalent(value={"back", "return"})
@NonnullByDefault
public class BackCommand
extends AbstractCommand<Player>
implements Reloadable {
    private final BackHandler handler = Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(BackHandler.class);
    private boolean sameDimensionCheck = false;
    private final String EXEMPT_PERMISSION = this.permissions.getPermissionWithSuffix("exempt.samedimension");

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.flags().permissionFlag(this.permissions.getPermissionWithSuffix("exempt.bordercheck"), new String[]{"b", "-border"}).flag(new String[]{"f", "-force"}).buildWith(GenericArguments.none())};
    }

    @Override
    protected Map<String, PermissionInformation> permissionSuffixesToRegister() {
        HashMap m = Maps.newHashMap();
        m.put("targets.death", PermissionInformation.getWithTranslation("permission.back.ondeath", SuggestedLevel.USER));
        m.put("targets.teleport", PermissionInformation.getWithTranslation("permission.back.onteleport", SuggestedLevel.USER));
        m.put("targets.portal", PermissionInformation.getWithTranslation("permission.back.onportal", SuggestedLevel.USER));
        m.put("exempt.samedimension", PermissionInformation.getWithTranslation("permission.back.exempt.samedimension", SuggestedLevel.MOD));
        m.put("exempt.bordercheck", PermissionInformation.getWithTranslation("permission.tppos.border", SuggestedLevel.ADMIN));
        return m;
    }

    @Override
    public CommandResult executeCommand(Player src, CommandContext args, Cause cause) throws Exception {
        Optional<Transform<World>> ol = this.handler.getLastLocation((User)src);
        if (!ol.isPresent()) {
            throw ReturnMessageException.fromKey((CommandSource)src, "command.back.noloc", new Object[0]);
        }
        Transform<World> loc = ol.get();
        if (this.sameDimensionCheck && src.getWorld().getUniqueId() != ((World)loc.getExtent()).getUniqueId() && !this.hasPermission((Subject)src, this.EXEMPT_PERMISSION)) {
            throw ReturnMessageException.fromKey((CommandSource)src, "command.back.sameworld", new Object[0]);
        }
        NucleusTeleportHandler.TeleportResult result = Nucleus.getNucleus().getTeleportHandler().teleportPlayer(src, loc, !args.hasAny("f"), !args.hasAny("b"));
        if (result.isSuccess()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.back.success", new String[0]));
            return CommandResult.success();
        }
        if (result == NucleusTeleportHandler.TeleportResult.FAILED_NO_LOCATION) {
            throw ReturnMessageException.fromKey("command.back.nosafe", new Object[0]);
        }
        throw ReturnMessageException.fromKey("command.back.cancelled", new Object[0]);
    }

    @Override
    public void onReload() throws Exception {
        this.sameDimensionCheck = ((BackConfig)((BackConfigAdapter)this.getServiceUnchecked(BackConfigAdapter.class)).getNodeOrDefault()).isOnlySameDimension();
    }
}

