/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.back.commands;

import io.github.nucleuspowered.nucleus.argumentparsers.NucleusRequirePermissionArgument;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.modules.back.services.BackHandler;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@NoModifiers
@Permissions(supportsOthers=true)
@RegisterCommand(value={"clearback"})
public class ClearBackCommand
extends AbstractCommand<CommandSource> {
    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{new NucleusRequirePermissionArgument(GenericArguments.optionalWeak((CommandElement)NucleusParameters.ONE_USER), this.permissions.getOthers())};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        boolean isSelf;
        User target = this.getUserFromArgs(User.class, src, "user", args);
        boolean bl = isSelf = src instanceof Player && ((Player)src).getUniqueId().equals(target.getUniqueId());
        if (!isSelf && !this.hasPermission((Subject)src, this.permissions.getOthers())) {
            throw ReturnMessageException.fromKey("command.clearback.other.noperm", new Object[0]);
        }
        ((BackHandler)this.getServiceUnchecked(BackHandler.class)).removeLastLocation(target);
        this.sendMessageTo(src, "command.clearback.success", new String[]{target.getName()});
        return CommandResult.success();
    }
}

