/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.chat.listeners;

import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.NameUtil;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.EventContexts;
import io.github.nucleuspowered.nucleus.api.chat.NucleusNoFormatChannel;
import io.github.nucleuspowered.nucleus.internal.interfaces.ListenerBase;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.messages.MessageProvider;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.internal.services.PermissionResolver;
import io.github.nucleuspowered.nucleus.internal.text.TextParsingUtils;
import io.github.nucleuspowered.nucleus.modules.chat.config.ChatConfig;
import io.github.nucleuspowered.nucleus.modules.chat.config.ChatConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.chat.config.ChatTemplateConfig;
import io.github.nucleuspowered.nucleus.modules.chat.util.TemplateUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.message.MessageChannelEvent;
import org.spongepowered.api.event.message.MessageEvent;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextRepresentable;
import org.spongepowered.api.text.TextTemplate;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.text.transform.SimpleTextFormatter;
import org.spongepowered.api.text.transform.SimpleTextTemplateApplier;
import org.spongepowered.api.util.Tuple;

public class ChatListener
implements Reloadable,
ListenerBase.Conditional {
    private static final String prefix = "nucleus.chat.";
    private static final Map<String, String> permissionToDesc = Maps.newHashMap();
    private static final Map<String, Tuple<String[], Function<String, String>>> replacements = ChatListener.createReplacements();
    private ChatConfig chatConfig = null;
    private final TemplateUtil templateUtil = Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(TemplateUtil.class);

    private static Map<String, Tuple<String[], Function<String, String>>> createReplacements() {
        HashMap<String, Tuple<String[], Function<String, String>>> t = new HashMap<String, Tuple<String[], Function<String, String>>>();
        MessageProvider mp = Nucleus.getNucleus().getMessageProvider();
        BiFunction<String, String, String> fss = (key, s) -> s.replaceAll("[&]+[" + key.toLowerCase() + key.toUpperCase() + "]", "");
        NameUtil.getColours().forEach((key, value) -> {
            t.put("&" + key, Tuple.of((Object)new String[]{"nucleus.chat.colour." + value.getName(), "nucleus.chat.color." + value.getName()}, s -> (String)fss.apply(key.toString(), (String)s)));
            permissionToDesc.put("nucleus.chat.colour." + value.getName(), mp.getMessageWithFormat("permission.chat.colourspec", value.getName().toLowerCase(), key.toString()));
            permissionToDesc.put("nucleus.chat.color." + value.getName(), mp.getMessageWithFormat("permission.chat.colorspec", value.getName().toLowerCase(), key.toString()));
        });
        NameUtil.getStyleKeys().entrySet().stream().filter(x -> ((Character)x.getKey()).charValue() != 'k').forEach(k -> {
            t.put("&" + k.getKey(), Tuple.of((Object)new String[]{"nucleus.chat.style." + ((String)k.getValue()).toLowerCase()}, s -> (String)fss.apply(((Character)k.getKey()).toString(), (String)s)));
            permissionToDesc.put("nucleus.chat.style." + ((String)k.getValue()).toLowerCase(), mp.getMessageWithFormat("permission.chat.stylespec", ((String)k.getValue()).toLowerCase(), ((Character)k.getKey()).toString()));
        });
        t.put("&k", Tuple.of((Object)new String[]{"nucleus.chat.magic"}, s -> s.replaceAll("[&]+[kK]", "")));
        return t;
    }

    public static String stripPermissionless(Subject source, String message) {
        if (message.contains("&")) {
            String m = message.toLowerCase();
            PermissionResolver resolver = Nucleus.getNucleus().getPermissionResolver();
            for (Map.Entry<String, Tuple<String[], Function<String, String>>> r : replacements.entrySet()) {
                if (!m.contains(r.getKey()) || !Arrays.stream((Object[])r.getValue().getFirst()).noneMatch(x -> resolver.hasPermission(source, (String)x))) continue;
                message = (String)((Function)r.getValue().getSecond()).apply(message);
            }
        }
        return message;
    }

    @Override
    public Map<String, PermissionInformation> getPermissions() {
        HashMap<String, PermissionInformation> mp = new HashMap<String, PermissionInformation>();
        mp.put("nucleus.chat.color", PermissionInformation.getWithTranslation("permission.chat.color", SuggestedLevel.ADMIN));
        mp.put("nucleus.chat.color.<color>", PermissionInformation.getWithTranslation("permission.chat.colorsingle", SuggestedLevel.ADMIN, false, true));
        mp.put("nucleus.chat.colour", PermissionInformation.getWithTranslation("permission.chat.colour", SuggestedLevel.ADMIN, true, false));
        mp.put("nucleus.chat.style", PermissionInformation.getWithTranslation("permission.chat.style", SuggestedLevel.ADMIN));
        mp.put("nucleus.chat.style.<style>", PermissionInformation.getWithTranslation("permission.chat.stylesingle", SuggestedLevel.ADMIN, false, true));
        mp.put("nucleus.chat.magic", PermissionInformation.getWithTranslation("permission.chat.magic", SuggestedLevel.ADMIN));
        mp.put("nucleus.chat.url", PermissionInformation.getWithTranslation("permission.chat.urls", SuggestedLevel.ADMIN));
        permissionToDesc.forEach((k, v) -> mp.put((String)k, new PermissionInformation((String)v, SuggestedLevel.ADMIN, true, false)));
        return mp;
    }

    @Listener(order=Order.EARLY, beforeModifications=true)
    public void onPlayerChat(MessageChannelEvent.Chat event) {
        Util.onPlayerSimulatedOrPlayer(event, this::onPlayerChatInternal);
    }

    private boolean shouldNotFormat(MessageChannelEvent.Chat event) {
        if (!event.getContext().get(EventContexts.SHOULD_FORMAT_CHANNEL).orElse(true).booleanValue()) {
            return true;
        }
        return event.getChannel().map(this::shouldNotFormat).orElseGet(() -> this.shouldNotFormat(event.getOriginalChannel()));
    }

    private boolean shouldNotFormat(MessageChannel channel) {
        return channel instanceof NucleusNoFormatChannel && !((NucleusNoFormatChannel)channel).formatMessages();
    }

    @Nullable
    private NucleusNoFormatChannel getChannel(MessageChannelEvent.Chat event) {
        if (event.getChannel().filter(x -> x instanceof NucleusNoFormatChannel).isPresent()) {
            return (NucleusNoFormatChannel)event.getChannel().get();
        }
        return event.getOriginalChannel() instanceof NucleusNoFormatChannel ? (NucleusNoFormatChannel)event.getOriginalChannel() : null;
    }

    private void onPlayerChatInternal(MessageChannelEvent.Chat event, Player player) {
        ChatTemplateConfig ctc;
        if (this.shouldNotFormat(event)) {
            NucleusNoFormatChannel channel = this.getChannel(event);
            if (channel != null && channel.removePrefix()) {
                event.getFormatter().setHeader((TextRepresentable)Text.EMPTY);
            }
            return;
        }
        MessageEvent.MessageFormatter eventFormatter = event.getFormatter();
        Text rawMessage = eventFormatter.getBody().isEmpty() ? event.getRawMessage() : eventFormatter.getBody().toText();
        SimpleTextFormatter headerFormatter = eventFormatter.getHeader();
        SimpleTextFormatter footerFormatter = eventFormatter.getFooter();
        if (this.chatConfig.isOverwriteEarlyPrefixes()) {
            eventFormatter.setHeader((TextRepresentable)Text.EMPTY);
            headerFormatter.clear();
        } else if (this.chatConfig.isTryRemoveMinecraftPrefix()) {
            for (SimpleTextTemplateApplier stta : eventFormatter.getHeader()) {
                if (!(stta instanceof MessageEvent.DefaultHeaderApplier)) continue;
                eventFormatter.getHeader().remove(stta);
            }
        }
        if (this.chatConfig.isOverwriteEarlySuffixes()) {
            footerFormatter.clear();
        }
        if (!(ctc = this.chatConfig.isUseGroupTemplates() ? this.templateUtil.getTemplateNow((Subject)player) : this.chatConfig.getDefaultTemplate()).getPrefix().isEmpty()) {
            SimpleTextTemplateApplier headerApplier = new SimpleTextTemplateApplier();
            headerApplier.setTemplate(TextTemplate.of((Object[])new Object[]{ctc.getPrefix().getForCommandSource((CommandSource)player)}));
            event.getFormatter().getHeader().add(headerApplier);
        }
        if (!ctc.getSuffix().isEmpty()) {
            SimpleTextTemplateApplier footerApplier = new SimpleTextTemplateApplier();
            footerApplier.setTemplate(TextTemplate.of((Object[])new Object[]{ctc.getSuffix().getForCommandSource((CommandSource)player)}));
            event.getFormatter().getFooter().add(footerApplier);
        }
        event.getFormatter().setBody((TextRepresentable)(this.chatConfig.isModifyMainMessage() ? this.useMessage(player, rawMessage, ctc) : rawMessage));
    }

    @Override
    public boolean shouldEnable() {
        return Nucleus.getNucleus().getConfigValue("chat", ChatConfigAdapter.class, ChatConfig::isModifychat).orElse(false);
    }

    private Text useMessage(Player player, Text rawMessage, ChatTemplateConfig chatTemplateConfig) {
        String m = TextSerializers.FORMATTING_CODE.serialize(rawMessage);
        if (this.chatConfig.isRemoveBlueUnderline()) {
            m = m.replaceAll("&9&n([A-Za-z0-9-.]+)(&r)?", "$1");
        }
        m = ChatListener.stripPermissionless((Subject)player, m);
        Text result = this.hasPermission((Subject)player, "nucleus.chat.url") ? TextParsingUtils.addUrls(m, !this.chatConfig.isRemoveBlueUnderline()) : TextSerializers.FORMATTING_CODE.deserialize(m);
        String chatcol = Util.getOptionFromSubject((Subject)player, "chatcolour", "chatcolor").orElseGet(chatTemplateConfig::getChatcolour);
        String chatstyle = Util.getOptionFromSubject((Subject)player, "chatstyle").orElseGet(chatTemplateConfig::getChatstyle);
        NameUtil nu = Nucleus.getNucleus().getNameUtil();
        return Text.of((Object[])new Object[]{nu.getColourFromString(chatcol), nu.getTextStyleFromString(chatstyle), result});
    }

    @Override
    public void onReload() {
        this.chatConfig = (ChatConfig)Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(ChatConfigAdapter.class).getNodeOrDefault();
    }
}

