/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.core.services;

import com.flowpowered.math.vector.Vector3d;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.service.NucleusPlayerMetadataService;
import io.github.nucleuspowered.nucleus.configurate.datatypes.LocationNode;
import io.github.nucleuspowered.nucleus.dataservices.modular.ModularUserService;
import io.github.nucleuspowered.nucleus.internal.annotations.APIService;
import io.github.nucleuspowered.nucleus.internal.interfaces.ServiceBase;
import io.github.nucleuspowered.nucleus.modules.core.datamodules.CoreUserDataModule;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;

@APIService(value=NucleusPlayerMetadataService.class)
@NonnullByDefault
public class PlayerMetadataService
implements NucleusPlayerMetadataService,
ServiceBase {
    @Override
    public Optional<NucleusPlayerMetadataService.Result> getUserData(UUID uuid) {
        return Nucleus.getNucleus().getUserDataManager().get(uuid, false).map(x$0 -> new ResultImpl((ModularUserService)x$0));
    }

    public class ResultImpl
    implements NucleusPlayerMetadataService.Result {
        private final User user;
        @Nullable
        private final Instant login;
        @Nullable
        private final Instant logout;
        @Nullable
        private final String lastIP;
        @Nullable
        private final LocationNode lastLocation;

        private ResultImpl(ModularUserService userService) {
            this.user = userService.getUser();
            CoreUserDataModule core = userService.get(CoreUserDataModule.class);
            this.login = core.getLastLogin().orElse(null);
            this.logout = core.getLastLogout().orElse(null);
            this.lastIP = core.getLastIp().orElse(null);
            this.lastLocation = core.getLogoutLocationSafe().orElse(null);
        }

        @Override
        public Optional<Instant> getLastLogin() {
            return Optional.ofNullable(this.login);
        }

        @Override
        public Optional<Instant> getLastLogout() {
            return Optional.ofNullable(this.logout);
        }

        @Override
        public Optional<String> getLastIP() {
            return Optional.ofNullable(this.lastIP);
        }

        @Override
        public Optional<Tuple<WorldProperties, Vector3d>> getLastLocation() {
            Optional pl = this.user.getPlayer();
            if (pl.isPresent()) {
                Location l = ((Player)pl.get()).getLocation();
                return Optional.of(Tuple.of((Object)((World)l.getExtent()).getProperties(), (Object)l.getPosition()));
            }
            try {
                if (this.lastLocation != null) {
                    return Optional.of(this.lastLocation.getLocationIfNotLoaded());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Optional.empty();
        }
    }
}

