/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.freezeplayer.listeners;

import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.interfaces.ListenerBase;
import io.github.nucleuspowered.nucleus.modules.freezeplayer.services.FreezePlayerService;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.UUID;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.action.InteractEvent;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.network.ClientConnectionEvent;

public class FreezePlayerListener
implements ListenerBase {
    private final FreezePlayerService service = Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(FreezePlayerService.class);
    private final Map<UUID, Instant> lastFreezeNotification = Maps.newHashMap();

    @Listener
    public void onPlayerMovement(MoveEntityEvent event, @Root Player player) {
        event.setCancelled(this.checkForFrozen(player, "freeze.cancelmove"));
    }

    @Listener
    public void onPlayerInteractBlock(InteractEvent event, @Root Player player) {
        event.setCancelled(this.checkForFrozen(player, "freeze.cancelinteract"));
    }

    @Listener
    public void onPlayerInteractBlock(InteractBlockEvent event, @Root Player player) {
        event.setCancelled(this.checkForFrozen(player, "freeze.cancelinteractblock"));
    }

    @Listener
    public void onPlayerDisconnect(ClientConnectionEvent.Disconnect event) {
        this.service.invalidate(event.getTargetEntity().getUniqueId());
    }

    private boolean checkForFrozen(Player player, String message) {
        if (this.service.isFrozen((User)player)) {
            Instant now = Instant.now();
            if (this.lastFreezeNotification.getOrDefault(player.getUniqueId(), now).isBefore(now)) {
                player.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat(message, new String[0]));
                this.lastFreezeNotification.put(player.getUniqueId(), now.plus(2L, ChronoUnit.SECONDS));
            }
            return true;
        }
        return false;
    }
}

