/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.home.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.nucleusdata.Home;
import io.github.nucleuspowered.nucleus.argumentparsers.HomeArgument;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.home.config.HomeConfig;
import io.github.nucleuspowered.nucleus.modules.home.config.HomeConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.home.events.UseHomeEvent;
import io.github.nucleuspowered.nucleus.modules.home.services.HomeHandler;
import io.github.nucleuspowered.nucleus.util.CauseStackHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@Permissions(suggestedLevel=SuggestedLevel.USER)
@RegisterCommand(value={"home"})
@EssentialsEquivalent(value={"home", "homes"}, notes="'/homes' will list homes, '/home' will teleport like Essentials did.")
@NonnullByDefault
public class HomeCommand
extends AbstractCommand<Player>
implements Reloadable {
    private final String home = "home";
    public static final String EXEMPT_SAMEDIMENSION_SUFFIX = "exempt.samedimension";
    private final HomeHandler homeHandler = Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(HomeHandler.class);
    private boolean isSafeTeleport = true;
    private boolean isPreventOverhang = true;
    private boolean isOnlySameDimension = false;

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.onlyOne((CommandElement)GenericArguments.optional((CommandElement)new HomeArgument((Text)Text.of((String)this.home), Nucleus.getNucleus())))};
    }

    @Override
    protected Map<String, PermissionInformation> permissionSuffixesToRegister() {
        return new HashMap<String, PermissionInformation>(){
            {
                this.put(HomeCommand.EXEMPT_SAMEDIMENSION_SUFFIX, PermissionInformation.getWithTranslation("permission.home.exempt.samedimension", SuggestedLevel.ADMIN));
            }
        };
    }

    @Override
    public CommandResult executeCommand(Player src, CommandContext args, Cause cause) throws Exception {
        int max = this.homeHandler.getMaximumHomes((User)src);
        int current = this.homeHandler.getHomeCount((User)src);
        if (this.isPreventOverhang && max < current) {
            throw ReturnMessageException.fromKey("command.home.overhang", String.valueOf(max), String.valueOf(current));
        }
        Optional owl = args.getOne(this.home);
        Home wl = owl.isPresent() ? (Home)owl.get() : this.homeHandler.getHome((User)src, "home").orElseThrow(() -> new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("args.home.nohome", "home")));
        Sponge.getServer().loadWorld(wl.getWorldProperties().orElseThrow(() -> ReturnMessageException.fromKey("command.home.invalid", wl.getName())));
        Location<World> targetLocation = wl.getLocation().orElseThrow(() -> ReturnMessageException.fromKey("command.home.invalid", wl.getName()));
        if (this.isOnlySameDimension && !((World)targetLocation.getExtent()).getUniqueId().equals(((World)src.getLocation().getExtent()).getUniqueId()) && !this.permissions.testSuffix((Subject)src, EXEMPT_SAMEDIMENSION_SUFFIX, (CommandSource)src, true)) {
            throw ReturnMessageException.fromKey("command.home.invalid", wl.getName());
        }
        UseHomeEvent event = CauseStackHelper.createFrameWithCausesWithReturn(c -> new UseHomeEvent((Cause)c, (User)src, wl), src);
        if (Sponge.getEventManager().post((Event)event)) {
            throw new ReturnMessageException(event.getCancelMessage().orElseGet(() -> Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("nucleus.eventcancelled", new String[0])));
        }
        if (Nucleus.getNucleus().getTeleportHandler().teleportPlayer(src, targetLocation, wl.getRotation(), this.isSafeTeleport).isSuccess()) {
            if (!wl.getName().equalsIgnoreCase("home")) {
                src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.home.success", wl.getName()));
            } else {
                src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.home.successdefault", new String[0]));
            }
            return CommandResult.success();
        }
        throw ReturnMessageException.fromKey("command.home.fail", wl.getName());
    }

    @Override
    public void onReload() {
        HomeConfig hc = (HomeConfig)Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(HomeConfigAdapter.class).getNodeOrDefault();
        this.isSafeTeleport = hc.isSafeTeleport();
        this.isPreventOverhang = hc.isPreventHomeCountOverhang();
        this.isOnlySameDimension = hc.isOnlySameDimension();
    }
}

