/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.home.listeners;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.EventContexts;
import io.github.nucleuspowered.nucleus.api.events.NucleusSendToSpawnEvent;
import io.github.nucleuspowered.nucleus.api.nucleusdata.Home;
import io.github.nucleuspowered.nucleus.api.nucleusdata.NamedLocation;
import io.github.nucleuspowered.nucleus.internal.interfaces.ListenerBase;
import io.github.nucleuspowered.nucleus.modules.home.config.HomeConfig;
import io.github.nucleuspowered.nucleus.modules.home.config.HomeConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.home.datamodules.HomeUserDataModule;
import io.github.nucleuspowered.nucleus.modules.spawn.events.SendToSpawnEvent;
import io.github.nucleuspowered.nucleus.util.CauseStackHelper;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.entity.living.humanoid.player.RespawnPlayerEvent;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.world.World;

public class RespawnConditionalListener
implements ListenerBase.Conditional {
    @Listener
    public void onRespawn(RespawnPlayerEvent event, @Getter(value="getTargetEntity") Player player) {
        Optional<Home> oh = Nucleus.getNucleus().getUserDataManager().getUnchecked((User)player).get(HomeUserDataModule.class).getHome("home");
        Optional ot = oh.flatMap(NamedLocation::getTransform);
        if (ot.isPresent()) {
            EventContext context = EventContext.builder().add(EventContexts.SPAWN_EVENT_TYPE, (Object)NucleusSendToSpawnEvent.Type.HOME_ON_DEATH).build();
            SendToSpawnEvent sEvent = new SendToSpawnEvent((Transform<World>)((Transform)ot.get()), (User)event.getTargetEntity(), CauseStackHelper.createCause(context, new Object[]{event.getTargetEntity()}));
            if (Sponge.getEventManager().post((Event)sEvent)) {
                event.getTargetEntity().sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.home.fail", oh.get().getName()));
                return;
            }
            event.setToTransform(sEvent.getTransformTo());
        }
    }

    @Override
    public boolean shouldEnable() {
        return Nucleus.getNucleus().getConfigValue("home", HomeConfigAdapter.class, HomeConfig::isRespawnAtHome).orElse(false);
    }
}

