/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.item.commands;

import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.argumentparsers.BoundedIntegerArgument;
import io.github.nucleuspowered.nucleus.argumentparsers.ImprovedCatalogTypeArgument;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.manipulator.mutable.item.EnchantmentData;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.item.enchantment.Enchantment;
import org.spongepowered.api.item.enchantment.EnchantmentType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Permissions
@RegisterCommand(value={"enchant"})
@EssentialsEquivalent(value={"enchant", "enchantment"})
public class EnchantCommand
extends AbstractCommand<Player> {
    private final String enchantmentKey = "enchantment";
    private final String levelKey = "level";

    @Override
    protected Map<String, PermissionInformation> permissionSuffixesToRegister() {
        HashMap msp = Maps.newHashMap();
        msp.put("unsafe", PermissionInformation.getWithTranslation("permission.enchant.unsafe", SuggestedLevel.ADMIN));
        return msp;
    }

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{new ImprovedCatalogTypeArgument((Text)Text.of((String)this.enchantmentKey), EnchantmentType.class), new BoundedIntegerArgument((Text)Text.of((String)this.levelKey), 0, Short.MAX_VALUE), GenericArguments.flags().permissionFlag(this.permissions.getPermissionWithSuffix("unsafe"), new String[]{"u", "-unsafe"}).flag(new String[]{"o", "-overwrite"}).buildWith(GenericArguments.none())};
    }

    @Override
    public CommandResult executeCommand(Player src, CommandContext args, Cause cause) {
        if (!src.getItemInHand(HandTypes.MAIN_HAND).isPresent()) {
            this.sendMessageTo((CommandSource)src, "command.enchant.noitem");
            return CommandResult.empty();
        }
        ItemStack itemInHand = (ItemStack)src.getItemInHand(HandTypes.MAIN_HAND).get();
        EnchantmentType enchantment = (EnchantmentType)args.getOne(this.enchantmentKey).get();
        int level = (Integer)args.getOne(this.levelKey).get();
        boolean allowUnsafe = args.hasAny("u");
        boolean allowOverwrite = args.hasAny("o");
        if (!allowUnsafe) {
            if (!enchantment.canBeAppliedToStack(itemInHand)) {
                this.sendMessageTo((CommandSource)src, "command.enchant.nounsafe.enchant", new Object[]{itemInHand});
                return CommandResult.empty();
            }
            if (level > enchantment.getMaximumLevel()) {
                this.sendMessageTo((CommandSource)src, "command.enchant.nounsafe.level", new Object[]{itemInHand});
                return CommandResult.empty();
            }
        }
        EnchantmentData ed = (EnchantmentData)itemInHand.getOrCreate(EnchantmentData.class).get();
        List currentEnchants = (List)ed.getListValue().get();
        if (level == 0) {
            if (!currentEnchants.removeIf(x -> x.getType().getId().equals(enchantment.getId()))) {
                this.sendMessageTo((CommandSource)src, "command.enchant.noenchantment", new Object[]{enchantment});
                return CommandResult.empty();
            }
        } else {
            List<Enchantment> enchantmentsToRemove = currentEnchants.stream().filter(x -> !x.getType().isCompatibleWith(enchantment) || x.getType().equals(enchantment)).collect(Collectors.toList());
            if (!allowOverwrite && !enchantmentsToRemove.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                enchantmentsToRemove.forEach(x -> {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(Util.getTranslatableIfPresent(x.getType()));
                });
                this.sendMessageTo((CommandSource)src, "command.enchant.overwrite", new String[]{sb.toString()});
                return CommandResult.empty();
            }
            currentEnchants.removeIf(enchantmentsToRemove::contains);
            currentEnchants.add(Enchantment.of((EnchantmentType)enchantment, (int)level));
        }
        ed.setElements(currentEnchants);
        DataTransactionResult dtr = itemInHand.offer((ValueContainer)ed);
        if (dtr.isSuccessful()) {
            src.setItemInHand(HandTypes.MAIN_HAND, itemInHand);
            if (level == 0) {
                this.sendMessageTo((CommandSource)src, "command.enchant.removesuccess", new Object[]{enchantment});
            } else {
                this.sendMessageTo((CommandSource)src, "command.enchant.success", new Object[]{enchantment, level});
            }
            return CommandResult.success();
        }
        this.sendMessageTo((CommandSource)src, "command.enchant.error", new Object[]{enchantment, level});
        return CommandResult.empty();
    }
}

