/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.item.commands;

import io.github.nucleuspowered.nucleus.internal.annotations.RequireExistenceOf;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import java.util.List;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.DataManipulatorBuilder;
import org.spongepowered.api.data.manipulator.mutable.item.PlainPagedData;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.plugin.meta.util.NonnullByDefault;

@Permissions(suggestedLevel=SuggestedLevel.ADMIN, supportsOthers=true)
@RegisterCommand(value={"unsignbook", "unsign"})
@NonnullByDefault
@RequireExistenceOf(value="org.spongepowered.api.data.manipulator.mutable.item.PlainPagedData")
public class UnsignBookCommand
extends AbstractCommand.SimpleTargetOtherPlayer {
    @Override
    protected CommandResult executeWithPlayer(CommandSource source, Player target, CommandContext args, boolean isSelf) throws Exception {
        Optional<ItemStack> bookToUnsign = target.getItemInHand(HandTypes.MAIN_HAND).filter(item -> item.getType().equals(ItemTypes.WRITTEN_BOOK));
        if (bookToUnsign.isPresent()) {
            ItemStack unsignedBook = ItemStack.builder().itemType(ItemTypes.WRITABLE_BOOK).itemData((DataManipulator)bookToUnsign.get().get(Keys.BOOK_PAGES).map(this::from).orElseGet(this::createData)).quantity(bookToUnsign.get().getQuantity()).build();
            target.setItemInHand(HandTypes.MAIN_HAND, unsignedBook);
            if (isSelf) {
                this.sendMessageTo(source, "command.unsignbook.success.self");
            } else {
                this.sendMessageTo(source, "command.unsignbook.success.other", new String[]{target.getName()});
            }
            return CommandResult.affectedItems((int)bookToUnsign.get().getQuantity());
        }
        if (isSelf) {
            throw ReturnMessageException.fromKey("command.unsignbook.notinhand.self", new Object[0]);
        }
        throw ReturnMessageException.fromKey("command.unsignbook.notinhand.other", target.getName());
    }

    private PlainPagedData from(List<Text> texts) {
        PlainPagedData ppd = this.createData();
        for (Text text : texts) {
            ppd.addElement((Object)TextSerializers.FORMATTING_CODE.serialize(text));
        }
        return ppd;
    }

    private PlainPagedData createData() {
        return (PlainPagedData)((DataManipulatorBuilder)Sponge.getDataManager().getManipulatorBuilder(PlainPagedData.class).get()).create();
    }
}

