/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.item.commands.lore;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.argumentparsers.PositiveIntegerArgument;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.modules.item.commands.lore.LoreCommand;
import java.util.List;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.mutable.item.LoreData;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(prefix="lore", mainOverride="set")
@NonnullByDefault
@RegisterCommand(value={"delete"}, subcommandOf=LoreCommand.class)
public class LoreDeleteCommand
extends AbstractCommand<Player> {
    private final String loreLine = "line";

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{new PositiveIntegerArgument((Text)Text.of((String)this.loreLine), false)};
    }

    @Override
    protected CommandResult executeCommand(Player src, CommandContext args, Cause cause) throws Exception {
        int line = (Integer)args.getOne(this.loreLine).get() - 1;
        ItemStack stack = (ItemStack)src.getItemInHand(HandTypes.MAIN_HAND).orElseThrow(() -> ReturnMessageException.fromKey("command.lore.clear.noitem", new Object[0]));
        LoreData loreData = (LoreData)stack.getOrCreate(LoreData.class).get();
        List loreList = (List)loreData.lore().get();
        if (loreList.size() < line) {
            throw ReturnMessageException.fromKey("command.lore.set.invalidLine", new Object[0]);
        }
        loreList.remove(line);
        if (stack.offer(Keys.ITEM_LORE, (Object)loreList).isSuccessful()) {
            src.setItemInHand(HandTypes.MAIN_HAND, stack);
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.lore.set.success", new String[0]));
            return CommandResult.success();
        }
        throw ReturnMessageException.fromKey("command.lore.set.fail", new Object[0]);
    }
}

