/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.note.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.internal.text.TextParsingUtils;
import io.github.nucleuspowered.nucleus.modules.note.data.NoteData;
import io.github.nucleuspowered.nucleus.modules.note.services.NoteHandler;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(suggestedLevel=SuggestedLevel.MOD)
@RunAsync
@NoModifiers
@NonnullByDefault
@RegisterCommand(value={"checknotes", "notes"})
public class CheckNotesCommand
extends AbstractCommand<CommandSource> {
    private final NoteHandler handler = (NoteHandler)this.getServiceUnchecked(NoteHandler.class);
    private final String playerKey = "subject";

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.onlyOne((CommandElement)GenericArguments.user((Text)Text.of((String)this.playerKey)))};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
        User user = (User)args.getOne(this.playerKey).get();
        List<NoteData> notes = this.handler.getNotesInternal(user);
        if (notes.isEmpty()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.checknotes.none", user.getName()));
            return CommandResult.success();
        }
        List messages = notes.stream().sorted(Comparator.comparing(NoteData::getDate)).map(x -> this.createMessage((NoteData)x, user, src)).collect(Collectors.toList());
        messages.add(0, Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.checknotes.info", new String[0]));
        PaginationService paginationService = (PaginationService)Sponge.getGame().getServiceManager().provideUnchecked(PaginationService.class);
        paginationService.builder().title(Text.builder().color(TextColors.GOLD).append(new Text[]{Text.of((String)Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("command.checknotes.header", user.getName()))}).build()).padding(Text.builder().color(TextColors.YELLOW).append(new Text[]{Text.of((String)"=")}).build()).contents(messages).sendTo((MessageReceiver)src);
        return CommandResult.success();
    }

    private Text createMessage(NoteData note, User user, CommandSource source) {
        String name;
        if (note.getNoterInternal().equals(Util.consoleFakeUUID)) {
            name = Sponge.getServer().getConsole().getName();
        } else {
            Optional ou = ((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).get(note.getNoterInternal());
            name = ou.map(User::getName).orElseGet(() -> Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("standard.unknown", new String[0]));
        }
        int id = this.handler.getNotesInternal(user).indexOf(note) + 1;
        Text.Builder actions = Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.checknotes.action", new String[0]).toBuilder();
        actions.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GOLD, " > "})});
        actions.append(new Text[]{Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.RED, Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("standard.action.delete", new String[0])})}).onHover((HoverAction)TextActions.showText((Text)Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.checknotes.hover.delete", new String[0]))).onClick((ClickAction)TextActions.runCommand((String)("/removenote " + user.getName() + " " + id))).build()});
        actions.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GOLD, " - "})});
        actions.append(new Text[]{Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("standard.action.return", new String[0])})}).onHover((HoverAction)TextActions.showText((Text)Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.checknotes.hover.return", new String[0]))).onClick((ClickAction)TextActions.runCommand((String)("/checknotes " + user.getName()))).build()});
        actions.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GOLD, " < "})});
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("MMM dd, yyyy").withZone(ZoneId.systemDefault());
        String date = dtf.format(note.getDate());
        Text nodeMessage = TextParsingUtils.addUrls(note.getNote());
        LiteralText.Builder information = Text.builder((String)name).onHover((HoverAction)TextActions.showText((Text)this.getMessageFor(source, "command.checknotes.hover.check"))).onClick((ClickAction)TextActions.executeCallback(commandSource -> {
            this.sendMessageTo((CommandSource)commandSource, "command.checknotes.id", new String[]{String.valueOf(id)});
            this.sendMessageTo((CommandSource)commandSource, "command.checknotes.date", new String[]{date});
            this.sendMessageTo((CommandSource)commandSource, "command.checknotes.noter", new String[]{name});
            this.sendMessageTo((CommandSource)commandSource, "command.checknotes.note", new Text[]{nodeMessage});
            commandSource.sendMessage(actions.build());
        }));
        Text.Builder message = Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, information.build()})}).append(new Text[]{Text.of((String)": ")}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.YELLOW, note.getNote()})});
        return message.build();
    }
}

