/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.playerinfo.commands;

import com.flowpowered.math.vector.Vector3d;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.internal.services.PlayerOnlineService;
import io.github.nucleuspowered.nucleus.modules.playerinfo.config.PlayerInfoConfig;
import io.github.nucleuspowered.nucleus.modules.playerinfo.config.PlayerInfoConfigAdapter;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

@Permissions(suggestedLevel=SuggestedLevel.USER, supportsOthers=true)
@RegisterCommand(value={"near"})
@EssentialsEquivalent(value={"near"})
@NonnullByDefault
public class NearCommand
extends AbstractCommand.SimpleTargetOtherUser
implements Reloadable {
    private static final NumberFormat formatter = NumberFormat.getInstance();
    private final String radiusKey = "radius";
    private int maxRadius;

    @Override
    protected Map<String, PermissionInformation> permissionSuffixesToRegister() {
        Map<String, PermissionInformation> pi = super.permissionSuffixesToRegister();
        pi.put("maxexempt", PermissionInformation.getWithTranslation("permission.near.maxexempt", SuggestedLevel.MOD));
        return pi;
    }

    @Override
    protected CommandElement[] additionalArguments() {
        return new CommandElement[]{GenericArguments.optionalWeak((CommandElement)GenericArguments.integer((Text)Text.of((String)this.radiusKey)))};
    }

    @Override
    protected CommandResult executeWithPlayer(CommandSource src, User user, CommandContext args, boolean isSelf) throws Exception {
        Vector3d position;
        Location location;
        if (user.isOnline()) {
            location = ((Player)user.getPlayer().get()).getLocation();
            position = location.getPosition();
        } else {
            World world = (World)user.getWorldUniqueId().flatMap(x -> Sponge.getServer().getWorld(x)).orElseThrow(() -> ReturnMessageException.fromKey(src, "command.near.location.nolocation", user.getName()));
            position = user.getPosition();
            location = new Location((Extent)world, position);
        }
        int radius = this.maxRadius;
        Optional radiusOpt = args.getOne(this.radiusKey);
        if (radiusOpt.isPresent()) {
            int inputRadius = (Integer)radiusOpt.get();
            if (inputRadius > this.maxRadius && this.permissions.testSuffix((Subject)src, "maxexempt")) {
                radius = inputRadius;
            } else {
                this.sendMessageTo(src, "command.near.radiustoobig", new Object[]{this.maxRadius});
            }
        }
        PlayerOnlineService playerOnlineService = this.getServiceManager().getServiceUnchecked(PlayerOnlineService.class);
        List messagesToSend = ((World)location.getExtent()).getNearbyEntities(location.getPosition(), (double)radius).stream().filter(Player.class::isInstance).map(Player.class::cast).filter(e -> e.getUniqueId() != user.getUniqueId() && playerOnlineService.isOnline(src, (User)e)).map(x -> Tuple.of((Object)x, (Object)position.distance(x.getPosition()))).sorted(Comparator.comparingDouble(Tuple::getSecond)).map(tuple -> this.createPlayerLine(src, (Tuple<Player, Double>)tuple)).collect(Collectors.toList());
        Util.getPaginationBuilder(src).title(this.getMessageFor(src, "command.near.playersnear", new String[]{user.getName()})).contents(messagesToSend).sendTo((MessageReceiver)src);
        return CommandResult.success();
    }

    private Text createPlayerLine(CommandSource src, Tuple<Player, Double> player) {
        Text.Builder line = Text.builder();
        this.getMessageFor(src, "command.near.playerdistancefrom", new String[]{((Player)player.getFirst()).getName()});
        line.append(new Text[]{this.getMessageFor(src, "command.near.playerdistancefrom", new String[]{((Player)player.getFirst()).getName(), formatter.format(Math.abs((Double)player.getSecond()))})}).onClick((ClickAction)TextActions.runCommand((String)("/tp " + ((Player)player.getFirst()).getName()))).onHover((HoverAction)TextActions.showText((Text)this.getMessageFor(src, "command.near.tpto", new String[]{((Player)player.getFirst()).getName()})));
        return line.build();
    }

    @Override
    public void onReload() {
        PlayerInfoConfigAdapter configAdapter = (PlayerInfoConfigAdapter)this.getServiceUnchecked(PlayerInfoConfigAdapter.class);
        this.maxRadius = ((PlayerInfoConfig)configAdapter.getNodeOrDefault()).getNear().getMaxRadius();
    }

    static {
        formatter.setMaximumFractionDigits(2);
    }
}

