/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.powertool.listeners;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.CommandPermissionHandler;
import io.github.nucleuspowered.nucleus.internal.interfaces.ListenerBase;
import io.github.nucleuspowered.nucleus.internal.traits.PermissionTrait;
import io.github.nucleuspowered.nucleus.internal.userprefs.UserPreferenceService;
import io.github.nucleuspowered.nucleus.modules.powertool.PowertoolUserPreferenceKeys;
import io.github.nucleuspowered.nucleus.modules.powertool.commands.PowertoolCommand;
import io.github.nucleuspowered.nucleus.modules.powertool.datamodules.PowertoolUserDataModule;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.action.InteractEvent;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.entity.InteractEntityEvent;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.filter.type.Exclude;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.service.permission.Subject;

public class PowertoolListener
implements ListenerBase,
PermissionTrait {
    private final CommandPermissionHandler permissionRegistry = Nucleus.getNucleus().getPermissionRegistry().getPermissionsForNucleusCommand(PowertoolCommand.class);
    private final String basePermission = this.permissionRegistry.getBase();
    private final UserPreferenceService userPreferenceService = this.getServiceUnchecked(UserPreferenceService.class);

    @Listener
    @Exclude(value={InteractBlockEvent.class})
    public void onUserInteract(InteractEvent event, @Root Player player) {
        PowertoolUserDataModule user;
        if (!this.hasPermission((Subject)player, this.basePermission) || !player.getItemInHand(HandTypes.MAIN_HAND).isPresent()) {
            return;
        }
        ItemType item = ((ItemStack)player.getItemInHand(HandTypes.MAIN_HAND).get()).getType();
        try {
            user = Nucleus.getNucleus().getUserDataManager().getUnchecked((User)player).get(PowertoolUserDataModule.class);
        }
        catch (Exception e) {
            Nucleus.getNucleus().printStackTraceIfDebugMode(e);
            return;
        }
        if (this.userPreferenceService.get(player.getUniqueId(), PowertoolUserPreferenceKeys.POWERTOOL_ENABLED).orElse(true).booleanValue()) {
            user.getPowertoolForItem(item).ifPresent(x -> {
                event.setCancelled(true);
                Player interacting = event instanceof InteractEntityEvent && ((InteractEntityEvent)event).getTargetEntity() instanceof Player ? (Player)((InteractEntityEvent)event).getTargetEntity() : null;
                if (interacting == null && x.stream().allMatch(i -> i.contains("{{subject}}"))) {
                    player.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("powertool.playeronly", new String[0]));
                    return;
                }
                x.forEach(s -> {
                    if (s.contains("{{subject}}")) {
                        if (interacting != null) {
                            s = s.replace("{{subject}}", interacting.getName());
                        } else {
                            return;
                        }
                    }
                    Sponge.getCommandManager().process((CommandSource)player, s);
                });
            });
        }
    }
}

