/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.rtp.config;

import com.flowpowered.math.GenericMath;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.rtp.RTPKernel;
import io.github.nucleuspowered.nucleus.api.rtp.RTPKernels;
import io.github.nucleuspowered.nucleus.configurate.settingprocessor.LowercaseMapKeySettingProcessor;
import io.github.nucleuspowered.relocate.nucleus.neutrino.annotations.ProcessSetting;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.config.NoMergeIfPresent;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.biome.BiomeTypes;
import org.spongepowered.api.world.storage.WorldProperties;

@ConfigSerializable
public class RTPConfig {
    @Setting(value="attempts", comment="config.rtp.attempts")
    private int noOfAttempts = 10;
    @Setting(value="radius", comment="config.rtp.radius")
    private int radius = 30000;
    @Setting(value="min-radius", comment="config.rtp.minradius")
    private int minRadius = 0;
    @Setting(value="minimum-y", comment="config.rtp.min-y")
    private int minY = 0;
    @Setting(value="maximum-y", comment="config.rtp.max-y")
    private int maxY = 255;
    @Setting(value="default-method", comment="config.rtp.defaultmethod")
    private String defaultRTPKernel = "nucleus:default";
    private RTPKernel lazyLoadedKernel;
    @Setting(value="per-world-permissions", comment="config.rtp.perworldperms")
    private boolean perWorldPermissions = false;
    @Setting(value="world-overrides", comment="config.rtp.perworldsect")
    @ProcessSetting(value={LowercaseMapKeySettingProcessor.class})
    private Map<String, PerWorldRTPConfig> perWorldRTPConfigList = new HashMap<String, PerWorldRTPConfig>(){
        {
            this.put("example", new PerWorldRTPConfig());
        }
    };
    @Setting(value="default-world", comment="config.rtp.defaultworld")
    private String defaultWorld = "";
    @NoMergeIfPresent
    @Setting(value="prohibited-biomes", comment="config.rtp.prohibitedbiomes")
    private Set<String> prohibitedBiomes = Sets.newHashSet((Object[])new String[]{BiomeTypes.OCEAN.getId(), BiomeTypes.DEEP_OCEAN.getId(), BiomeTypes.FROZEN_OCEAN.getId()});
    private ImmutableSet<BiomeType> lazyLoadProhbitedBiomes;

    public int getNoOfAttempts() {
        return this.noOfAttempts;
    }

    private Optional<PerWorldRTPConfig> get(@Nullable String worldName) {
        if (worldName == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.perWorldRTPConfigList.get(worldName.toLowerCase()));
    }

    public int getMinRadius(@Nullable String worldName) {
        return this.get(worldName).map(x -> ((PerWorldRTPConfig)x).minRadius).orElse(this.minRadius);
    }

    public int getRadius(@Nullable String worldName) {
        return this.get(worldName).map(x -> ((PerWorldRTPConfig)x).radius).orElse(this.radius);
    }

    public int getMinY(@Nullable String worldName) {
        return this.get(worldName).map(x -> GenericMath.clamp((int)((PerWorldRTPConfig)x).minY, (int)0, (int)Math.min(255, ((PerWorldRTPConfig)x).maxY))).orElseGet(() -> GenericMath.clamp((int)this.minY, (int)0, (int)Math.min(255, this.maxY)));
    }

    public int getMaxY(@Nullable String worldName) {
        return this.get(worldName).map(x -> GenericMath.clamp((int)((PerWorldRTPConfig)x).maxY, (int)Math.max(0, ((PerWorldRTPConfig)x).minY), (int)255)).orElseGet(() -> GenericMath.clamp((int)this.maxY, (int)Math.max(0, this.minY), (int)255));
    }

    public boolean isPerWorldPermissions() {
        return this.perWorldPermissions;
    }

    public Optional<WorldProperties> getDefaultWorld() {
        if (this.defaultWorld == null || this.defaultWorld.equalsIgnoreCase("")) {
            return Optional.empty();
        }
        return Sponge.getServer().getWorldProperties(this.defaultWorld).filter(WorldProperties::isEnabled);
    }

    public ImmutableSet<BiomeType> getProhibitedBiomes() {
        if (this.lazyLoadProhbitedBiomes == null) {
            this.lazyLoadProhbitedBiomes = (ImmutableSet)this.prohibitedBiomes.stream().map(x -> x.contains(":") ? x : "minecraft:" + x).map(x -> Sponge.getRegistry().getType(BiomeType.class, x).orElse(null)).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        }
        return this.lazyLoadProhbitedBiomes;
    }

    public RTPKernel getKernel() {
        if (this.lazyLoadedKernel == null) {
            String kernelId = this.defaultRTPKernel;
            kernelId = kernelId.contains(":") ? kernelId : "nucleus:" + kernelId;
            Optional rtpKernel = Sponge.getRegistry().getType(RTPKernel.class, kernelId);
            if (!rtpKernel.isPresent()) {
                Nucleus.getNucleus().getLogger().warn("Kernel with ID {} could not be found. Falling back to the default.", (Object)this.defaultRTPKernel);
                this.lazyLoadedKernel = RTPKernels.DEFAULT;
            } else {
                this.lazyLoadedKernel = (RTPKernel)rtpKernel.get();
            }
        }
        return this.lazyLoadedKernel;
    }

    public RTPKernel getKernel(String world) {
        return this.get(world).map(x -> {
            if (((PerWorldRTPConfig)x).lazyLoadedKernel == null) {
                String kernelId = ((PerWorldRTPConfig)x).defaultRTPKernel;
                kernelId = kernelId.contains(":") ? kernelId : "nucleus:" + kernelId;
                Optional rtpKernel = Sponge.getRegistry().getType(RTPKernel.class, kernelId);
                if (!rtpKernel.isPresent()) {
                    Nucleus.getNucleus().getLogger().warn("Kernel with ID {} for world {} could not be found. Falling back to the default.", (Object)((PerWorldRTPConfig)x).defaultRTPKernel, (Object)world);
                    ((PerWorldRTPConfig)x).lazyLoadedKernel = RTPKernels.DEFAULT;
                } else {
                    ((PerWorldRTPConfig)x).lazyLoadedKernel = (RTPKernel)rtpKernel.get();
                }
            }
            return ((PerWorldRTPConfig)x).lazyLoadedKernel;
        }).orElseGet(this::getKernel);
    }

    @ConfigSerializable
    public static class PerWorldRTPConfig {
        @Setting(value="radius")
        private int radius = 30000;
        @Setting(value="min-radius")
        private int minRadius = 0;
        @Setting(value="minimum-y")
        private int minY = 0;
        @Setting(value="maximum-y")
        private int maxY = 255;
        @Setting(value="default-method", comment="config.rtp.defaultmethod")
        private String defaultRTPKernel = "nucleus:default";
        private RTPKernel lazyLoadedKernel;
    }
}

