/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.serverlist.listener;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.text.NucleusTextTemplate;
import io.github.nucleuspowered.nucleus.internal.interfaces.ListenerBase;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.text.NucleusTextTemplateImpl;
import io.github.nucleuspowered.nucleus.modules.serverlist.config.ServerListConfig;
import io.github.nucleuspowered.nucleus.modules.serverlist.config.ServerListConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.serverlist.datamodules.ServerListGeneralDataModule;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.server.ClientPingServerEvent;
import org.spongepowered.api.text.Text;

public class WhitelistServerListListener
implements Reloadable,
ListenerBase.Conditional {
    private final Random random = new Random();
    private ServerListConfig config;

    @Listener(order=Order.LATE)
    public void onServerListPing(ClientPingServerEvent event, @Getter(value="getResponse") ClientPingServerEvent.Response response) {
        List<NucleusTextTemplateImpl> list;
        if (!Sponge.getServer().hasWhitelist()) {
            return;
        }
        Optional<Text> ott = Nucleus.getNucleus().getGeneralService().get(ServerListGeneralDataModule.class).getMessage();
        if (!ott.isPresent() && !this.config.getWhitelist().isEmpty() && (list = this.config.getWhitelist()) != null) {
            NucleusTextTemplate template = list.get(this.random.nextInt(list.size()));
            response.setDescription(template.getForCommandSource((CommandSource)Sponge.getServer().getConsole()));
        }
    }

    @Override
    public void onReload() {
        this.config = Nucleus.getNucleus().getConfigValue("server-list", ServerListConfigAdapter.class, Function.identity()).orElseGet(ServerListConfig::new);
    }

    @Override
    public boolean shouldEnable() {
        return Nucleus.getNucleus().getConfigValue("server-list", ServerListConfigAdapter.class, ServerListConfig::enableWhitelistListener).orElse(false);
    }
}

