/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.spawn.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.modules.spawn.config.GlobalSpawnConfig;
import java.util.List;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;

@ConfigSerializable
public class SpawnConfig {
    @Setting(value="spawn-on-login", comment="config.spawn.onlogin")
    private boolean spawnOnLogin = false;
    @Setting(value="use-safe-spawn", comment="config.spawn.safe")
    private boolean safeTeleport = true;
    @Setting(value="force-first-spawn", comment="config.spawn.forcefirstspawn")
    private boolean forceFirstSpawn = false;
    @Setting(value="handle-on-respawn", comment="config.spawn.handleonrespawn")
    private boolean handleOnRespawn = true;
    @Setting(value="global-spawn", comment="config.spawn.global.base")
    private GlobalSpawnConfig globalSpawn = new GlobalSpawnConfig();
    @Setting(value="per-world-permissions", comment="config.spawn.worlds")
    private boolean perWorldPerms = false;
    @Setting(value="affect-bed-spawn", comment="config.spawn.bedspawn")
    private boolean redirectBedSpawn = true;
    @Setting(value="spawn-on-login-exempt-worlds", comment="config.spawn.onloginsameworld")
    private List<String> spawnOnLoginExemptWorld = Lists.newArrayList();

    public boolean isSpawnOnLogin() {
        return this.spawnOnLogin;
    }

    public boolean isSafeTeleport() {
        return this.safeTeleport;
    }

    public boolean isForceFirstSpawn() {
        return this.forceFirstSpawn;
    }

    public GlobalSpawnConfig getGlobalSpawn() {
        return this.globalSpawn;
    }

    public boolean isPerWorldPerms() {
        return this.perWorldPerms;
    }

    public boolean isRedirectBedSpawn() {
        return this.redirectBedSpawn;
    }

    public List<String> getOnLoginExemptWorlds() {
        return this.spawnOnLoginExemptWorld == null ? ImmutableList.of() : this.spawnOnLoginExemptWorld;
    }

    public boolean isHandleOnRespawn() {
        return this.handleOnRespawn;
    }
}

