/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.staffchat;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.chat.NucleusChatChannel;
import io.github.nucleuspowered.nucleus.internal.text.NucleusTextTemplateImpl;
import io.github.nucleuspowered.nucleus.internal.traits.InternalServiceManagerTrait;
import io.github.nucleuspowered.nucleus.internal.traits.PermissionTrait;
import io.github.nucleuspowered.nucleus.internal.userprefs.UserPreferenceService;
import io.github.nucleuspowered.nucleus.modules.staffchat.StaffChatUserPrefKeys;
import io.github.nucleuspowered.nucleus.modules.staffchat.commands.StaffChatCommand;
import io.github.nucleuspowered.nucleus.modules.staffchat.config.StaffChatConfig;
import io.github.nucleuspowered.nucleus.modules.staffchat.config.StaffChatConfigAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.source.ProxySource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.channel.MutableMessageChannel;
import org.spongepowered.api.text.chat.ChatType;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.util.annotation.NonnullByDefault;

public abstract class StaffChatMessageChannel
implements NucleusChatChannel.StaffChat,
PermissionTrait,
InternalServiceManagerTrait {
    private static boolean formatting = false;
    private static NucleusTextTemplateImpl template;
    private static TextColor colour;

    public static StaffChatMessageChannel getInstance() {
        Preconditions.checkState((ImmutableStaffChatMessageChannel.INSTANCE != null ? 1 : 0) != 0, (Object)"StaffChatMessageChannel#Instance");
        return ImmutableStaffChatMessageChannel.INSTANCE;
    }

    public void send(@Nullable Object sender, Text original, ChatType type) {
        Object source = !(sender instanceof CommandSource) ? (sender instanceof String ? new NamedSource((String)sender) : Sponge.getServer().getConsole()) : (CommandSource)sender;
        NucleusChatChannel.StaffChat.super.send(sender, this.format((CommandSource)source, (MessageReceiver)Sponge.getServer().getConsole(), original), type);
    }

    @Override
    public Text format(CommandSource sender, MessageReceiver receiver, Text text) {
        return Text.of((Object[])new Object[]{template.getForCommandSource(sender), colour, text});
    }

    @Override
    public boolean formatMessages() {
        return formatting;
    }

    private static void onReload() {
        Nucleus.getNucleus().getConfigAdapter("staff-chat", StaffChatConfigAdapter.class).ifPresent(x -> {
            formatting = ((StaffChatConfig)x.getNodeOrDefault()).isIncludeStandardChatFormatting();
            template = ((StaffChatConfig)x.getNodeOrDefault()).getMessageTemplate();
            colour = ((StaffChatConfig)x.getNodeOrDefault()).getColour();
        });
    }

    @NonnullByDefault
    private class NamedSource
    implements ProxySource {
        private final String name;

        NamedSource(String name) {
            this.name = name;
        }

        public CommandSource getOriginalSource() {
            return Sponge.getServer().getConsole();
        }

        public String getName() {
            return this.name;
        }

        public Optional<CommandSource> getCommandSource() {
            return Optional.of(this.getOriginalSource());
        }

        public SubjectCollection getContainingCollection() {
            return this.getOriginalSource().getContainingCollection();
        }

        public SubjectReference asSubjectReference() {
            return this.getOriginalSource().asSubjectReference();
        }

        public boolean isSubjectDataPersisted() {
            return this.getOriginalSource().isSubjectDataPersisted();
        }

        public SubjectData getSubjectData() {
            return this.getOriginalSource().getSubjectData();
        }

        public SubjectData getTransientSubjectData() {
            return this.getOriginalSource().getTransientSubjectData();
        }

        public Tristate getPermissionValue(Set<Context> contexts, String permission) {
            return this.getOriginalSource().getPermissionValue(contexts, permission);
        }

        public boolean isChildOf(Set<Context> contexts, SubjectReference parent) {
            return this.getOriginalSource().isChildOf(contexts, parent);
        }

        public List<SubjectReference> getParents(Set<Context> contexts) {
            return this.getOriginalSource().getParents();
        }

        public Optional<String> getOption(Set<Context> contexts, String key) {
            return this.getOriginalSource().getOption(contexts, key);
        }

        public String getIdentifier() {
            return this.getName();
        }

        public Set<Context> getActiveContexts() {
            return this.getOriginalSource().getActiveContexts();
        }

        public void sendMessage(Text message) {
            this.getOriginalSource().sendMessage(message);
        }

        public MessageChannel getMessageChannel() {
            return this.getOriginalSource().getMessageChannel();
        }

        public void setMessageChannel(MessageChannel channel) {
            this.getOriginalSource().setMessageChannel(channel);
        }
    }

    public static class MutableStaffChatMessageChannel
    extends StaffChatMessageChannel
    implements MutableMessageChannel {
        private final List<MessageReceiver> messageReceivers = new ArrayList<MessageReceiver>();

        MutableStaffChatMessageChannel(Collection<MessageReceiver> receivers) {
            this.messageReceivers.addAll(receivers);
        }

        public Collection<MessageReceiver> getMembers() {
            return ImmutableList.copyOf(this.messageReceivers);
        }

        public boolean addMember(MessageReceiver member) {
            return this.messageReceivers.add(member);
        }

        public boolean removeMember(MessageReceiver member) {
            return this.messageReceivers.remove(member);
        }

        public void clearMembers() {
            this.messageReceivers.clear();
        }

        public MutableMessageChannel asMutable() {
            return this;
        }
    }

    public static class ImmutableStaffChatMessageChannel
    extends StaffChatMessageChannel {
        private static StaffChatMessageChannel INSTANCE = new ImmutableStaffChatMessageChannel();
        private final String basePerm;

        private ImmutableStaffChatMessageChannel() {
            Nucleus.getNucleus().registerReloadable(() -> StaffChatMessageChannel.onReload());
            StaffChatMessageChannel.onReload();
            this.basePerm = Nucleus.getNucleus().getPermissionRegistry().getPermissionsForNucleusCommand(StaffChatCommand.class).getBase();
        }

        @Nonnull
        public Collection<MessageReceiver> getMembers() {
            List<MessageReceiver> c = Sponge.getServer().getOnlinePlayers().stream().filter(this::test).collect(Collectors.toList());
            c.add((MessageReceiver)Sponge.getServer().getConsole());
            return c;
        }

        public MutableMessageChannel asMutable() {
            return new MutableStaffChatMessageChannel(this.getMembers());
        }

        private boolean test(Player player) {
            if (this.hasPermission((Subject)player, this.basePerm)) {
                return ((UserPreferenceService)this.getServiceUnchecked(UserPreferenceService.class)).getPreferenceFor((User)player, StaffChatUserPrefKeys.VIEW_STAFF_CHAT).orElse(true);
            }
            return false;
        }
    }
}

