/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.staffchat.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.EventContexts;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.internal.text.TextParsingUtils;
import io.github.nucleuspowered.nucleus.internal.userprefs.UserPreferenceService;
import io.github.nucleuspowered.nucleus.modules.staffchat.StaffChatMessageChannel;
import io.github.nucleuspowered.nucleus.modules.staffchat.StaffChatUserPrefKeys;
import io.github.nucleuspowered.nucleus.modules.staffchat.datamodules.StaffChatTransientModule;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.chat.ChatTypes;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(suggestedLevel=SuggestedLevel.MOD)
@NoModifiers
@RegisterCommand(value={"staffchat", "sc", "a"})
@NonnullByDefault
public class StaffChatCommand
extends AbstractCommand<CommandSource> {
    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{NucleusParameters.OPTIONAL_MESSAGE};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        boolean result;
        Optional toSend = args.getOne("message");
        if (toSend.isPresent()) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                Player pl;
                frame.addContext(EventContexts.SHOULD_FORMAT_CHANNEL, (Object)StaffChatMessageChannel.getInstance().formatMessages());
                if (src instanceof Player) {
                    pl = (Player)src;
                    frame.pushCause((Object)pl);
                    frame.addContext(EventContextKeys.PLAYER_SIMULATED, (Object)pl.getProfile());
                    MessageChannel mc = pl.getMessageChannel();
                    pl.setMessageChannel((MessageChannel)StaffChatMessageChannel.getInstance());
                    pl.simulateChat(TextParsingUtils.addUrls((String)toSend.get()), Sponge.getCauseStackManager().getCurrentCause());
                    pl.setMessageChannel(mc);
                    ((UserPreferenceService)this.getServiceUnchecked(UserPreferenceService.class)).setPreferenceFor((User)pl, StaffChatUserPrefKeys.VIEW_STAFF_CHAT, true);
                } else {
                    StaffChatMessageChannel.getInstance().send(src, TextParsingUtils.addUrls((String)toSend.get()), ChatTypes.CHAT);
                }
                pl = CommandResult.success();
                return pl;
            }
        }
        if (!(src instanceof Player)) {
            throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.staffchat.consoletoggle", new String[0]));
        }
        Player player = (Player)src;
        StaffChatTransientModule s = Nucleus.getNucleus().getUserDataManager().get((User)player).map(y -> y.getTransient(StaffChatTransientModule.class)).orElseGet(StaffChatTransientModule::new);
        boolean bl = result = !(src.getMessageChannel() instanceof StaffChatMessageChannel);
        if (result) {
            s.setPreviousMessageChannel(player.getMessageChannel());
            src.setMessageChannel((MessageChannel)StaffChatMessageChannel.getInstance());
            ((UserPreferenceService)this.getServiceUnchecked(UserPreferenceService.class)).setPreferenceFor((User)player, StaffChatUserPrefKeys.VIEW_STAFF_CHAT, true);
        } else {
            src.setMessageChannel(s.getPreviousMessageChannel().orElse(MessageChannel.TO_ALL));
        }
        this.sendMessageTo(src, "command.staffchat." + (result ? "on" : "off"));
        return CommandResult.success();
    }
}

