/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.staffchat.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.internal.userprefs.UserPreferenceService;
import io.github.nucleuspowered.nucleus.modules.staffchat.StaffChatMessageChannel;
import io.github.nucleuspowered.nucleus.modules.staffchat.StaffChatUserPrefKeys;
import io.github.nucleuspowered.nucleus.modules.staffchat.datamodules.StaffChatTransientModule;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(suggestedLevel=SuggestedLevel.MOD, mainOverride="staffchat")
@NoModifiers
@RegisterCommand(value={"toggleviewstaffchat", "vsc", "togglevsc"})
@NonnullByDefault
public class ToggleStaffChatCommand
extends AbstractCommand<Player> {
    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{NucleusParameters.OPTIONAL_ONE_TRUE_FALSE};
    }

    @Override
    public CommandResult executeCommand(Player src, CommandContext args, Cause cause) throws Exception {
        UserPreferenceService ups = (UserPreferenceService)this.getServiceUnchecked(UserPreferenceService.class);
        boolean result = args.getOne("true|false").orElseGet(() -> ups.getPreferenceFor((User)src, StaffChatUserPrefKeys.VIEW_STAFF_CHAT).orElse(true));
        ups.setPreferenceFor((User)src, StaffChatUserPrefKeys.VIEW_STAFF_CHAT, !result);
        if (!result && src.getMessageChannel() == StaffChatMessageChannel.getInstance()) {
            StaffChatTransientModule s = Nucleus.getNucleus().getUserDataManager().get((User)src).map(y -> y.getTransient(StaffChatTransientModule.class)).orElseGet(StaffChatTransientModule::new);
            src.setMessageChannel(s.getPreviousMessageChannel().orElse(MessageChannel.TO_ALL));
        }
        this.sendMessageTo((CommandSource)src, "command.staffchat.view." + (result ? "on" : "off"));
        return CommandResult.success();
    }
}

