/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.teleport.commands;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.modules.teleport.events.RequestEvent;
import io.github.nucleuspowered.nucleus.modules.teleport.services.TeleportHandler;
import io.github.nucleuspowered.nucleus.util.CauseStackHelper;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(prefix="teleport")
@NoModifiers
@NonnullByDefault
@RegisterCommand(value={"tpaall", "tpaskall"})
@RunAsync
@EssentialsEquivalent(value={"tpaall"})
public class TeleportAskAllHereCommand
extends AbstractCommand<Player> {
    private final TeleportHandler tpHandler = (TeleportHandler)this.getServiceUnchecked(TeleportHandler.class);

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.flags().flag(new String[]{"f"}).buildWith(GenericArguments.none())};
    }

    @Override
    public CommandResult executeCommand(Player src, CommandContext args, Cause cause) {
        ArrayList cancelled = Lists.newArrayList();
        Sponge.getServer().getOnlinePlayers().forEach(x -> {
            if (x.equals(src)) {
                return;
            }
            RequestEvent.PlayerToCause event = new RequestEvent.PlayerToCause(CauseStackHelper.createCause(src), (Player)x);
            if (Sponge.getEventManager().post((Event)event)) {
                cancelled.add(x);
                return;
            }
            TeleportHandler.TeleportBuilder tb = this.tpHandler.getBuilder().setFrom((Player)x).setTo(src).setSafe(args.getOne("f").orElse(false) == false).setBypassToggle(true).setSilentSource(true);
            TeleportHandler.TeleportPrep tp = new TeleportHandler.TeleportPrep(Instant.now().plus(30L, ChronoUnit.SECONDS), null, 0.0, tb);
            this.tpHandler.addAskQuestion(x.getUniqueId(), tp);
            x.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.tpahere.question", src.getName()));
            this.tpHandler.getAcceptDenyMessage(src, tp).ifPresent(arg_0 -> ((Player)x).sendMessage(arg_0));
        });
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.tpaall.success", new String[0]));
        if (!cancelled.isEmpty()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.tpall.cancelled", cancelled.stream().map(User::getName).collect(Collectors.joining(", "))));
        }
        return CommandResult.success();
    }
}

