/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.teleport.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoWarmup;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NotifyIfAFK;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.annotations.command.SetCooldownManually;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ContinueMode;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.teleport.config.TeleportConfig;
import io.github.nucleuspowered.nucleus.modules.teleport.config.TeleportConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.teleport.events.RequestEvent;
import io.github.nucleuspowered.nucleus.modules.teleport.services.TeleportHandler;
import io.github.nucleuspowered.nucleus.util.CauseStackHelper;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(prefix="teleport", suggestedLevel=SuggestedLevel.USER, supportsSelectors=true)
@NoWarmup(generateConfigEntry=true, generatePermissionDocs=true)
@RegisterCommand(value={"tpa", "teleportask", "call", "tpask"})
@RunAsync
@NonnullByDefault
@EssentialsEquivalent(value={"tpa", "call", "tpask"})
@NotifyIfAFK(value={"player"})
@SetCooldownManually
public class TeleportAskCommand
extends AbstractCommand<Player>
implements Reloadable {
    private final TeleportHandler tpHandler = (TeleportHandler)this.getServiceUnchecked(TeleportHandler.class);
    private boolean isCooldownOnAsk = false;

    @Override
    public Map<String, PermissionInformation> permissionSuffixesToRegister() {
        HashMap<String, PermissionInformation> m = new HashMap<String, PermissionInformation>();
        m.put("force", PermissionInformation.getWithTranslation("permission.teleport.force", SuggestedLevel.ADMIN));
        return m;
    }

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.flags().permissionFlag(this.permissions.getPermissionWithSuffix("force"), new String[]{"f"}).buildWith(NucleusParameters.ONE_PLAYER)};
    }

    @Override
    protected ContinueMode preProcessChecks(Player source, CommandContext args) {
        return TeleportHandler.canTeleportTo(this.permissions, (CommandSource)source, (User)args.requireOne("player")) ? ContinueMode.CONTINUE : ContinueMode.STOP;
    }

    @Override
    public CommandResult executeCommand(Player src, CommandContext args, Cause cause) throws Exception {
        double cost;
        Player target = (Player)args.requireOne("player");
        if (src.equals(target)) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.teleport.self", new String[0]));
            return CommandResult.empty();
        }
        RequestEvent.CauseToPlayer event = new RequestEvent.CauseToPlayer(CauseStackHelper.createCause(src), target);
        if (Sponge.getEventManager().post((Event)event)) {
            throw new ReturnMessageException(event.getCancelMessage().orElseGet(() -> Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.tpa.eventfailed", new String[0])));
        }
        TeleportHandler.TeleportBuilder tb = this.tpHandler.getBuilder().setFrom(src).setTo(target).setSafe(args.getOne("f").orElse(false) == false);
        int warmup = this.getWarmup(src);
        if (warmup > 0) {
            tb.setWarmupTime(warmup);
        }
        if ((cost = this.getCost((CommandSource)src, args)) > 0.0) {
            tb.setCharge(src).setCost(cost);
        }
        if (this.isCooldownOnAsk) {
            this.setCooldown(src);
        } else {
            tb.setSuccessCallback(this::setCooldown);
        }
        TeleportHandler.TeleportPrep tp = new TeleportHandler.TeleportPrep(Instant.now().plus(30L, ChronoUnit.SECONDS), (User)src, cost, tb);
        this.tpHandler.addAskQuestion(target.getUniqueId(), tp);
        target.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.tpa.question", src.getName()));
        this.tpHandler.getAcceptDenyMessage(src, tp).ifPresent(arg_0 -> ((Player)target).sendMessage(arg_0));
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.tpask.sent", target.getName()));
        return CommandResult.success();
    }

    @Override
    public void onReload() throws Exception {
        this.isCooldownOnAsk = ((TeleportConfig)((TeleportConfigAdapter)this.getServiceUnchecked(TeleportConfigAdapter.class)).getNodeOrDefault()).isCooldownOnAsk();
    }
}

