/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.vanish.services;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.ReregisterService;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.interfaces.ServiceBase;
import io.github.nucleuspowered.nucleus.internal.services.PlayerOnlineService;
import io.github.nucleuspowered.nucleus.internal.traits.InternalServiceManagerTrait;
import io.github.nucleuspowered.nucleus.internal.traits.PermissionTrait;
import io.github.nucleuspowered.nucleus.modules.vanish.config.VanishConfig;
import io.github.nucleuspowered.nucleus.modules.vanish.config.VanishConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.vanish.services.VanishService;
import java.time.Instant;
import java.util.Optional;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.permission.Subject;

@ReregisterService(value=PlayerOnlineService.class)
public class VanishPlayerOnlineService
implements PlayerOnlineService,
ServiceBase,
PermissionTrait,
InternalServiceManagerTrait,
Reloadable {
    private boolean allCanSee = false;

    @Override
    public boolean isOnline(CommandSource src, User player) {
        if (player.isOnline()) {
            if (this.getServiceUnchecked(VanishService.class).isVanished(player)) {
                return this.allCanSee || this.hasPermission((Subject)src, "nucleus.vanish.see");
            }
            return true;
        }
        return false;
    }

    @Override
    public Optional<Instant> lastSeen(CommandSource src, User player) {
        if (this.isOnline(src, player) || !player.isOnline() || !this.getServiceUnchecked(VanishService.class).getLastVanishTime(player.getUniqueId()).isPresent()) {
            return player.get(Keys.LAST_DATE_PLAYED);
        }
        return this.getServiceUnchecked(VanishService.class).getLastVanishTime(player.getUniqueId());
    }

    @Override
    public void onReload() throws Exception {
        this.allCanSee = !((VanishConfig)Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(VanishConfigAdapter.class).getNodeOrDefault()).isTryHidePlayers();
    }
}

