/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.vanish.services;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.interfaces.ServiceBase;
import io.github.nucleuspowered.nucleus.internal.traits.PermissionTrait;
import io.github.nucleuspowered.nucleus.modules.vanish.config.VanishConfig;
import io.github.nucleuspowered.nucleus.modules.vanish.config.VanishConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.vanish.datamodules.VanishUserDataModule;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.tab.TabListEntry;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;

public class VanishService
implements Reloadable,
PermissionTrait,
ServiceBase {
    private boolean isAlter = false;
    private final Map<UUID, Instant> lastVanish = new HashMap<UUID, Instant>();

    @Override
    public void onReload() {
        String property = System.getProperty("nucleus.vanish.tablist.enable");
        this.isAlter = property != null && !property.isEmpty() && ((VanishConfig)Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(VanishConfigAdapter.class).getNodeOrDefault()).isAlterTabList();
    }

    public boolean isVanished(User player) {
        return Nucleus.getNucleus().getUserDataManager().getUnchecked(player).get(VanishUserDataModule.class).isVanished();
    }

    public void vanishPlayer(User player) {
        this.vanishPlayer(player, false);
    }

    public void vanishPlayer(User player, boolean delay) {
        VanishUserDataModule service = Nucleus.getNucleus().getUserDataManager().getUnchecked(player).get(VanishUserDataModule.class);
        service.setVanished(true);
        if (delay) {
            Task.builder().execute(() -> this.vanishPlayerInternal(player)).delayTicks(0L).name("Nucleus Vanish runnable").submit((Object)Nucleus.getNucleus());
        } else {
            this.lastVanish.put(player.getUniqueId(), Instant.now());
            this.vanishPlayerInternal(player);
        }
    }

    private void vanishPlayerInternal(User player) {
        VanishUserDataModule service = Nucleus.getNucleus().getUserDataManager().getUnchecked(player).get(VanishUserDataModule.class);
        if (service.isVanished()) {
            player.offer(Keys.VANISH, (Object)true);
            player.offer(Keys.VANISH_IGNORES_COLLISION, (Object)true);
            player.offer(Keys.VANISH_PREVENTS_TARGETING, (Object)true);
            if (this.isAlter) {
                Sponge.getServer().getOnlinePlayers().stream().filter(x -> !player.equals(x) || !this.hasPermission((Subject)x, "nucleus.vanish.see")).forEach(x -> x.getTabList().removeEntry(player.getUniqueId()));
            }
        }
    }

    public void unvanishPlayer(User user) {
        VanishUserDataModule service = Nucleus.getNucleus().getUserDataManager().getUnchecked(user).get(VanishUserDataModule.class);
        service.setVanished(false);
        user.offer(Keys.VANISH, (Object)false);
        user.offer(Keys.VANISH_IGNORES_COLLISION, (Object)false);
        user.offer(Keys.VANISH_PREVENTS_TARGETING, (Object)false);
        if (this.isAlter && user instanceof Player) {
            Player player = (Player)user;
            Sponge.getServer().getOnlinePlayers().forEach(x -> {
                if (!x.getTabList().getEntry(player.getUniqueId()).isPresent()) {
                    x.getTabList().addEntry(TabListEntry.builder().displayName((Text)Text.of((String)player.getName())).profile(player.getProfile()).gameMode((GameMode)player.gameMode().get()).latency(player.getConnection().getLatency()).list(x.getTabList()).build());
                }
            });
        }
    }

    public void setLastVanishedTime(UUID pl, Instant instant) {
        this.lastVanish.put(pl, instant);
    }

    Optional<Instant> getLastVanishTime(UUID pl) {
        return Optional.ofNullable(this.lastVanish.get(pl));
    }

    public void clearLastVanishTime(UUID pl) {
        this.lastVanish.remove(pl);
    }
}

