/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.world.listeners;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.interfaces.ListenerBase;
import io.github.nucleuspowered.nucleus.modules.world.datamodules.WorldgenWorldDataModule;
import io.github.nucleuspowered.nucleus.modules.world.services.WorldHelper;
import java.util.concurrent.TimeUnit;
import org.spongepowered.api.GameState;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.event.world.LoadWorldEvent;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.world.World;

public class WorldGenListener
implements ListenerBase {
    @Listener
    public void onStart(GameStartedServerEvent event) {
        Task.builder().execute(() -> Sponge.getServer().getWorlds().forEach(this::onWorldLoad)).delay(1L, TimeUnit.SECONDS).submit((Object)Nucleus.getNucleus());
    }

    @Listener
    public void onWorldLoad(LoadWorldEvent event) {
        if (Sponge.getGame().getState() == GameState.SERVER_STARTED) {
            Task.builder().execute(() -> this.onWorldLoad(event.getTargetWorld())).delay(1L, TimeUnit.SECONDS).submit((Object)Nucleus.getNucleus());
        }
    }

    private void onWorldLoad(World world) {
        try {
            WorldHelper worldHelper = this.getServiceUnchecked(WorldHelper.class);
            Nucleus.getNucleus().getWorldDataManager().getWorld(world).ifPresent(mws -> {
                WorldgenWorldDataModule worldgenWorldDataModule = mws.get(WorldgenWorldDataModule.class);
                if (worldgenWorldDataModule.isStart() && worldHelper.startPregenningForWorld(world, worldgenWorldDataModule.isAggressive(), worldgenWorldDataModule.getSaveTime(), worldgenWorldDataModule.getTickPercent(), worldgenWorldDataModule.getTickFreq(), true)) {
                    this.sendMessageTo((CommandSource)Sponge.getServer().getConsole(), "command.world.gen.started", world.getName());
                }
            });
        }
        catch (IllegalStateException e) {
            Nucleus.getNucleus().getLogger().error("Could not determine World Generation restart status for world {}, WorldProperties could not be loaded from the Sponge World Manager (Sponge.getServer().getWorldProperties({}) returned empty.)", (Object)world.getName(), (Object)world.getUniqueId());
            e.printStackTrace();
        }
    }
}

