/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.config.AbstractConfigAdapter;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.config.NoMergeIfPresent;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.config.TypedAbstractConfigAdapter;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.IncorrectAdapterTypeException;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.NoModuleException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.commented.SimpleCommentedConfigurationNode;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import ninja.leaping.configurate.transformation.ConfigurationTransformation;

public class AbstractAdaptableConfig<N extends ConfigurationNode, T extends ConfigurationLoader<N>> {
    private Map<String, AbstractConfigAdapter<?>> moduleConfigAdapters = Maps.newHashMap();
    private final T loader;
    private N node;
    private final Supplier<ConfigurationNode> nodeCreator;
    private final Function<ConfigurationOptions, ConfigurationOptions> optionsTransformer;

    public AbstractAdaptableConfig(T loader) throws IOException {
        this(loader, () -> loader.createEmptyNode(), x -> x);
    }

    public AbstractAdaptableConfig(T loader, Supplier<ConfigurationNode> nodeCreator, Function<ConfigurationOptions, ConfigurationOptions> optionsTransformer) throws IOException {
        Preconditions.checkNotNull(loader);
        Preconditions.checkNotNull(nodeCreator);
        this.loader = loader;
        this.nodeCreator = nodeCreator;
        this.optionsTransformer = optionsTransformer;
        this.load();
    }

    public final ConfigurationNode createNode() {
        return this.nodeCreator.get();
    }

    public void load() throws IOException {
        this.node = this.loader.load(this.optionsTransformer.apply(this.loader.getDefaultOptions()));
    }

    public final Map<String, ? extends AbstractConfigAdapter<?>> getAllConfigAdapters() {
        return ImmutableMap.copyOf(this.moduleConfigAdapters);
    }

    public final <R extends AbstractConfigAdapter<?>> R getConfigAdapterForModule(String module, Class<R> adapterClass) throws NoModuleException, IncorrectAdapterTypeException {
        if (!this.moduleConfigAdapters.containsKey(module.toLowerCase())) {
            throw new NoModuleException(module);
        }
        AbstractConfigAdapter<?> aca = this.moduleConfigAdapters.get(module);
        if (adapterClass.isInstance(aca)) {
            return (R)((AbstractConfigAdapter)adapterClass.cast(aca));
        }
        throw new IncorrectAdapterTypeException();
    }

    public final void attachConfigAdapter(String module, AbstractConfigAdapter<?> configAdapter) throws IOException {
        this.attachConfigAdapter(module, configAdapter, null);
    }

    public final void attachConfigAdapter(String module, AbstractConfigAdapter<?> configAdapter, @Nullable String header) throws IOException {
        if (this.moduleConfigAdapters.containsKey(module.toLowerCase())) {
            throw new IllegalArgumentException();
        }
        configAdapter.attachConfig(module.toLowerCase(), this, () -> this.nodeCreator.get().setValue((Object)this.node.getNode(new Object[]{module.toLowerCase()})), n -> this.node.getNode(new Object[]{module.toLowerCase()}).setValue(n), this.nodeCreator, header);
        this.moduleConfigAdapters.put(module.toLowerCase(), configAdapter);
    }

    public final boolean detachConfigAdapter(String module) {
        return this.moduleConfigAdapters.remove(module.toLowerCase()) != null;
    }

    public final void refreshConfigurationNode() {
        this.moduleConfigAdapters.values().forEach(x -> {
            try {
                x.refreshConfigurationNode();
            }
            catch (ObjectMappingException e) {
                e.printStackTrace();
            }
        });
    }

    public void save() throws IOException {
        this.save(false);
    }

    public void save(boolean refresh) throws IOException {
        if (refresh) {
            this.refreshConfigurationNode();
        }
        this.loader.save(this.node);
    }

    public void saveAdapterDefaults(boolean processNoMergeIfPresent) throws IOException {
        SimpleCommentedConfigurationNode n = SimpleCommentedConfigurationNode.root();
        Stack moduleStack = new Stack();
        ArrayList doNotMerge = Lists.newArrayList();
        this.moduleConfigAdapters.forEach((arg_0, arg_1) -> this.lambda$saveAdapterDefaults$4(processNoMergeIfPresent, moduleStack, doNotMerge, (CommentedConfigurationNode)n, arg_0, arg_1));
        this.node.mergeValuesFrom((ConfigurationNode)n);
        this.moduleConfigAdapters.forEach((k, v) -> {
            ConfigurationNode nodeToTransform = this.node.getNode(new Object[]{k.toLowerCase()});
            if (!nodeToTransform.isVirtual()) {
                v.manualTransform(nodeToTransform);
                List<AbstractConfigAdapter.Transformation> transformations = v.getTransformations();
                if (!transformations.isEmpty() && v.isAttached()) {
                    ConfigurationTransformation.Builder ctBuilder = ConfigurationTransformation.builder();
                    transformations.forEach(x -> ctBuilder.addAction(x.getObjectPath(), x.getAction()));
                    ctBuilder.build().apply(nodeToTransform);
                }
                this.node.getNode(new Object[]{k.toLowerCase()}).setValue((Object)nodeToTransform);
            }
        });
        this.save();
    }

    private void getDoNotMerge(Stack<String> keySoFar, Class<?> configSerialisable, List<Object[]> doNotMergeList) {
        for (Field field : configSerialisable.getDeclaredFields()) {
            field.setAccessible(true);
            if (!field.isAnnotationPresent(Setting.class)) continue;
            String value = field.getAnnotation(Setting.class).value();
            if (value.equals("")) {
                value = field.getName();
            }
            keySoFar.push(value);
            if (field.isAnnotationPresent(NoMergeIfPresent.class)) {
                doNotMergeList.add(keySoFar.toArray(new String[keySoFar.size()]));
            } else if (field.getType().isAnnotationPresent(ConfigSerializable.class)) {
                this.getDoNotMerge(keySoFar, field.getType(), doNotMergeList);
            }
            keySoFar.pop();
        }
    }

    private /* synthetic */ void lambda$saveAdapterDefaults$4(boolean processNoMergeIfPresent, Stack moduleStack, List doNotMerge, CommentedConfigurationNode n, String k, AbstractConfigAdapter v) {
        ConfigurationNode cn = v.getDefaults();
        if (cn.getParent() != null) {
            cn = cn.getParent();
        }
        if (processNoMergeIfPresent) {
            if (v instanceof TypedAbstractConfigAdapter) {
                Object o = ((TypedAbstractConfigAdapter)v).getDefaultObject();
                this.getDoNotMerge(moduleStack, o.getClass(), doNotMerge);
            }
            if (!doNotMerge.isEmpty()) {
                for (Object[] keys : doNotMerge) {
                    ConfigurationNode toCheck = this.node.getNode(new Object[]{k}).getNode(keys);
                    if (toCheck.isVirtual() || toCheck.getValue() == null) continue;
                    cn.getNode(keys).setValue(null);
                    cn.getNode(keys).getParent().removeChild(keys[keys.length - 1]);
                }
                doNotMerge.clear();
            }
        }
        n.getNode(new Object[]{k.toLowerCase()}).setValue((Object)cn);
    }
}

