/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.cmdbuilder;

import com.google.inject.Inject;
import com.mcsimonflash.sponge.cmdbuilder.command.GetMeta;
import com.mcsimonflash.sponge.cmdbuilder.command.SetMeta;
import com.mcsimonflash.sponge.cmdbuilder.internal.Scripts;
import com.mcsimonflash.sponge.cmdbuilder.internal.Util;
import com.mcsimonflash.sponge.cmdbuilder.type.ParserType;
import com.mcsimonflash.sponge.cmdbuilder.type.ParserTypes;
import com.mcsimonflash.sponge.cmdbuilder.type.ValueType;
import com.mcsimonflash.sponge.cmdbuilder.type.ValueTypes;
import com.mcsimonflash.sponge.cmdcontrol.core.CmdPlugin;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.registry.Registry;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.registry.RegistryService;
import java.util.Optional;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.command.SendCommandEvent;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.plugin.Dependency;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;

@Plugin(id="cmdbuilder", name="CmdBuilder", version="1.3.0", dependencies={@Dependency(id="cmdcontrol")}, url="https://ore.spongepowered.org/Simon_Flash/CmdBuilder", authors={"Simon_Flash"})
public class CmdBuilder
extends CmdPlugin {
    private static CmdBuilder instance;
    private static final Registry<ParserType> PARSER_REGISTRY;
    private static final Registry<ValueType> VALUE_REGISTRY;
    public static final RegistryService<ParserType> PARSER_TYPES;
    public static final RegistryService<ValueType> VALUE_TYPES;

    @Inject
    public CmdBuilder(PluginContainer container) {
        super(container);
        instance = this;
        CmdBuilder.registerParserType(ParserTypes.BOOLEAN, container);
        CmdBuilder.registerParserType(ParserTypes.CHOICES, container);
        CmdBuilder.registerParserType(ParserTypes.DOUBLE, container);
        CmdBuilder.registerParserType(ParserTypes.INTEGER, container);
        CmdBuilder.registerParserType(ParserTypes.ITEM, container);
        CmdBuilder.registerParserType(ParserTypes.JOINED_STRINGS, container);
        CmdBuilder.registerParserType(ParserTypes.PLAYER, container);
        CmdBuilder.registerParserType(ParserTypes.SOURCE, container);
        CmdBuilder.registerParserType(ParserTypes.STRING, container);
        CmdBuilder.registerParserType(ParserTypes.TRISTATE, container);
        CmdBuilder.registerParserType(ParserTypes.USER, container);
        CmdBuilder.registerParserType(ParserTypes.POSITION, container);
        CmdBuilder.registerParserType(ParserTypes.WORLD, container);
        CmdBuilder.registerValueType(ValueTypes.BOOLEAN, container);
        CmdBuilder.registerValueType(ValueTypes.DOUBLE, container);
        CmdBuilder.registerValueType(ValueTypes.INTEGER, container);
        CmdBuilder.registerValueType(ValueTypes.ITEM, container);
        CmdBuilder.registerValueType(ValueTypes.PLAYER, container);
        CmdBuilder.registerValueType(ValueTypes.SOURCE, container);
        CmdBuilder.registerValueType(ValueTypes.STRING, container);
        CmdBuilder.registerValueType(ValueTypes.TRISTATE, container);
        CmdBuilder.registerValueType(ValueTypes.USER, container);
        CmdBuilder.registerValueType(ValueTypes.UUID, container);
        CmdBuilder.registerValueType(ValueTypes.VECTOR_3D, container);
        CmdBuilder.registerValueType(ValueTypes.WORLD, container);
    }

    @Listener
    public void onInit(GameInitializationEvent event) {
        this.getCommands().register(GetMeta.class);
        this.getCommands().register(SetMeta.class);
        Util.initialize();
    }

    @Listener
    public void onReload(GameReloadEvent event) {
        Util.initialize();
    }

    @Listener
    public void onSendCommand(SendCommandEvent event, @Root CommandSource src) {
        Optional<CommandResult> result = Scripts.process(src, event.getCommand() + " " + event.getArguments());
        if (result.isPresent()) {
            event.setCancelled(true);
            event.setResult(result.get());
        }
    }

    public static CmdBuilder get() {
        return instance;
    }

    public static boolean registerParserType(ParserType type, PluginContainer container) {
        return PARSER_REGISTRY.register(type.getName(), (Object)type, container);
    }

    public static boolean registerValueType(ValueType type, PluginContainer container) {
        return VALUE_REGISTRY.register(type.getName(), (Object)type, container);
    }

    static {
        PARSER_REGISTRY = Registry.of();
        VALUE_REGISTRY = Registry.of();
        PARSER_TYPES = RegistryService.of(PARSER_REGISTRY);
        VALUE_TYPES = RegistryService.of(VALUE_REGISTRY);
    }
}

