/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.cmdbuilder.internal;

import com.mcsimonflash.sponge.cmdbuilder.CmdBuilder;
import com.mcsimonflash.sponge.cmdbuilder.internal.Scripts;
import com.mcsimonflash.sponge.cmdbuilder.internal.Util;
import com.mcsimonflash.sponge.cmdbuilder.miscellaneous.Source;
import com.mcsimonflash.sponge.cmdbuilder.script.Argument;
import com.mcsimonflash.sponge.cmdbuilder.script.Executor;
import com.mcsimonflash.sponge.cmdbuilder.script.Metadata;
import com.mcsimonflash.sponge.cmdbuilder.script.Script;
import com.mcsimonflash.sponge.cmdbuilder.type.ParserType;
import com.mcsimonflash.sponge.cmdbuilder.type.ValueType;
import com.mcsimonflash.sponge.cmdbuilder.type.ValueTypeEntry;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.configuration.ConfigHolder;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.configuration.ConfigurationException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.stream.Collectors;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import org.spongepowered.api.asset.Asset;

public class Config {
    private static Path rootDir = CmdBuilder.get().getDirectory();
    private static Path scriptDir = rootDir.resolve("scripts");
    private static Path storageDir = rootDir.resolve("storage");
    private static ConfigHolder<CommentedConfigurationNode> core;
    private static ConfigHolder<CommentedConfigurationNode> users;

    public static void load() {
        try {
            core = Config.getLoader(rootDir, "cmdbuilder.conf", true);
            users = Config.getLoader(storageDir, "users.conf", false);
            if (Files.notExists(scriptDir, new LinkOption[0])) {
                Config.getLoader(scriptDir, "item.script", true);
                Config.getLoader(scriptDir, "lighten.script", true);
                Config.getLoader(scriptDir, "magic.script", true);
            }
            Files.walk(scriptDir, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(Config::loadScript);
        }
        catch (IOException e) {
            CmdBuilder.get().getLogger().error("An unexpected IOException occurred loading files.");
            e.printStackTrace();
        }
    }

    private static ConfigHolder<CommentedConfigurationNode> getLoader(Path dir, String name, boolean asset) throws IOException {
        try {
            Path path = dir.resolve(name);
            if (Files.notExists(path, new LinkOption[0])) {
                Files.createDirectories(dir, new FileAttribute[0]);
                if (asset) {
                    ((Asset)CmdBuilder.get().getContainer().getAsset(name).get()).copyToFile(path);
                } else {
                    Files.createFile(path, new FileAttribute[0]);
                }
            }
            return ConfigHolder.of((ConfigurationLoader)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(path)).build());
        }
        catch (IOException e) {
            CmdBuilder.get().getLogger().error("Unable to load config file " + name + ".");
            throw e;
        }
    }

    public static void loadScript(Path path) {
        String name = path.getFileName().toString();
        name = name.contains(".") ? name.substring(0, name.indexOf(".")) : name;
        try {
            ConfigHolder config = ConfigHolder.of((ConfigurationLoader)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(path)).build());
            Scripts.register(Script.builder().name(name).arguments(config.getNode(new Object[]{"arguments"}).getChildrenList().stream().map(a -> Argument.builder().name(a.getNode(new Object[]{"name"}).getString("")).parser((ParserType)CmdBuilder.PARSER_TYPES.getValue(a.getNode(new Object[]{"type"}).getString("")).orElseThrow(() -> new IllegalArgumentException("Unknown parser type " + a.getNode(new Object[]{"type"}).getString("undefined")))).meta(a.getNode(new Object[]{"meta"})).build()).collect(Collectors.toList())).executors(config.getNode(new Object[]{"executors"}).getChildrenList().stream().map(e -> Executor.builder().delay(e.getNode(new Object[]{"delay"}).getLong(0L)).command(e.getNode(new Object[]{"command"}).getString("")).source(Source.getSourceOrThrow(e.getNode(new Object[]{"source"}).getString("server"))).build()).collect(Collectors.toList())).metadata(Metadata.builder().aliases(Util.getObjectList(config.getNode(new Object[]{"metadata", "aliases"}), String.class)).cooldown(config.getNode(new Object[]{"metadata", "cooldown"}).getLong(0L)).cost(config.getNode(new Object[]{"metadata", "cost"}).getDouble(0.0)).override(config.getNode(new Object[]{"metadata", "override"}).getBoolean()).build()).build());
        }
        catch (IOException e2) {
            CmdBuilder.get().getLogger().error("An unexpected IOException occurred loading script '" + name + "'.");
            e2.printStackTrace();
        }
        catch (IllegalArgumentException e3) {
            CmdBuilder.get().getLogger().error("Error loading script '" + name + "': " + e3.getMessage());
        }
    }

    public static long getCooldown(UUID uuid, Script script) {
        return ((CommentedConfigurationNode)users.getNode(new Object[]{uuid.toString(), "cooldowns", script.getName()})).getLong(0L);
    }

    public static boolean setCooldown(UUID uuid, Script script, long cooldown) {
        ((CommentedConfigurationNode)users.getNode(new Object[]{uuid.toString(), "cooldowns", script.getName()})).setValue((Object)cooldown);
        return users.save();
    }

    public static ValueTypeEntry getMeta(UUID uuid, String name) throws ConfigurationException {
        CommentedConfigurationNode node = ((CommentedConfigurationNode)users.getNode(new Object[]{uuid.toString(), "meta"})).getNode((Object[])name.split("\\."));
        return ((ValueType)CmdBuilder.VALUE_TYPES.getValue(node.getNode(new Object[]{"type"}).getString("")).orElseThrow(() -> Config.lambda$getMeta$4((ConfigurationNode)node))).deserializeEntry(node.getNode(new Object[]{"value"}));
    }

    public static boolean setMeta(UUID uuid, String name, ValueTypeEntry entry) {
        CommentedConfigurationNode node = ((CommentedConfigurationNode)users.getNode(new Object[]{uuid.toString(), "meta"})).getNode((Object[])name.split("\\."));
        node.getNode(new Object[]{"type"}).setValue((Object)entry.getType().getName());
        entry.getType().serialize(node.getNode(new Object[]{"value"}), entry.getValue());
        return users.save();
    }

    private static /* synthetic */ ConfigurationException lambda$getMeta$4(ConfigurationNode node) {
        return new ConfigurationException(node, "Unknown value type %s.", new Object[]{node.getNode(new Object[]{"type"}).getString("undefined")});
    }
}

