/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.cmdbuilder.mixin;

import com.google.common.collect.ImmutableList;
import com.mcsimonflash.sponge.cmdbuilder.internal.Scripts;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandMessageFormatting;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.dispatcher.SimpleDispatcher;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.command.TabCompleteEvent;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.SpongeApiTranslationHelper;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.command.SpongeCommandManager;

@Mixin(value={SpongeCommandManager.class}, remap=false)
public class MixinSpongeCommandManager {
    @Shadow
    @Final
    private SimpleDispatcher dispatcher;

    @Overwrite
    public List<String> getSuggestions(CommandSource src, String arguments, @Nullable Location<World> targetPosition, boolean usingBlock) {
        List<String> suggestions = Scripts.complete(src, arguments, targetPosition);
        if (suggestions instanceof ImmutableList) {
            return suggestions;
        }
        try {
            List spongeSuggestions = this.dispatcher.getSuggestions(src, arguments, targetPosition);
            Sponge.getCauseStackManager().pushCause((Object)src);
            String[] split = arguments.split(" ", 2);
            TabCompleteEvent.Command event = SpongeEventFactory.createTabCompleteEventCommand((Cause)Sponge.getCauseStackManager().getCurrentCause(), (List)ImmutableList.copyOf((Collection)spongeSuggestions), (List)spongeSuggestions, (String)(split.length > 1 ? split[1] : ""), (String)split[0], (String)arguments, Optional.ofNullable(targetPosition), (boolean)usingBlock);
            if (!Sponge.getGame().getEventManager().post((Event)event)) {
                suggestions.addAll(event.getTabCompletions());
            }
            Sponge.getCauseStackManager().popCause();
        }
        catch (CommandException e) {
            src.sendMessage(CommandMessageFormatting.error((Text)SpongeApiTranslationHelper.t((String)"Error getting suggestions: %s", (Object[])new Object[]{e.getText()})));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Error occurred while tab completing '%s'", arguments), e);
        }
        return ImmutableList.copyOf(suggestions);
    }
}

