/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.cmdbuilder.script;

import com.google.common.base.Preconditions;
import com.mcsimonflash.sponge.cmdbuilder.type.ParserType;
import com.mcsimonflash.sponge.cmdbuilder.type.ValueTypeEntry;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.configuration.NodeUtils;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.SimpleConfigurationNode;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;

public class Argument<T> {
    private String name;
    private ParserType<T> parser;
    private ConfigurationNode meta;
    private CommandElement element;

    private Argument(String name, ParserType<T> parser, ConfigurationNode meta) throws IllegalArgumentException {
        this.name = name;
        this.parser = parser;
        this.meta = meta;
        this.element = parser.getParser(meta).toElement(name);
    }

    public ValueTypeEntry<T> collectArg(CommandContext args) throws IllegalArgumentException {
        return this.parser.getType().createEntry(args.getOne(this.name).orElseThrow(() -> new IllegalArgumentException("No argument found for name '" + this.name + "'.")));
    }

    public String getName() {
        return this.name;
    }

    public ParserType<T> getParser() {
        return this.parser;
    }

    public ConfigurationNode getMeta() {
        return NodeUtils.copy((ConfigurationNode)this.meta);
    }

    public CommandElement getElement() {
        return this.element;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T> {
        private String name;
        private ParserType<T> parser;
        private ConfigurationNode meta;

        public Builder<T> name(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> parser(ParserType<T> parser) {
            this.parser = parser;
            return this;
        }

        public Builder<T> meta(ConfigurationNode meta) {
            this.meta = NodeUtils.copy((ConfigurationNode)meta);
            return this;
        }

        public Argument<T> build() {
            Preconditions.checkArgument((this.name != null && !this.name.isEmpty() ? 1 : 0) != 0, (Object)"'name' must be defined");
            Preconditions.checkArgument((this.parser != null ? 1 : 0) != 0, (Object)"'parser' must be defined.");
            return new Argument(this.name, this.parser, (ConfigurationNode)(this.meta != null ? this.meta : SimpleConfigurationNode.root()));
        }
    }
}

